/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.nhttp;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.nhttp.Util;
import org.apache.axis2.transport.nhttp.util.PipeImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.HttpPost;

public class Axis2HttpRequest {
    private static final Log log = LogFactory.getLog((Class)Axis2HttpRequest.class);
    private EndpointReference epr = null;
    private HttpHost httpHost = null;
    private MessageContext msgContext = null;
    private PipeImpl pipe = null;
    MessageFormatter messageFormatter = null;
    OMOutputFormat format = null;

    public Axis2HttpRequest(EndpointReference epr, HttpHost httpHost, MessageContext msgContext) {
        this.epr = epr;
        this.httpHost = httpHost;
        this.msgContext = msgContext;
        this.format = Util.getOMOutputFormat(msgContext);
        try {
            this.messageFormatter = TransportUtils.getMessageFormatter((MessageContext)msgContext);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Cannot find a suitable MessageFormatter : " + axisFault.getMessage()));
        }
        try {
            this.pipe = new PipeImpl();
        }
        catch (IOException e) {
            log.error((Object)"Error creating pipe to write message body");
        }
    }

    public EndpointReference getEpr() {
        return this.epr;
    }

    public HttpHost getHttpHost() {
        return this.httpHost;
    }

    public MessageContext getMsgContext() {
        return this.msgContext;
    }

    public HttpRequest getRequest() throws IOException {
        String soapAction;
        HttpPost httpRequest = new HttpPost(this.epr.getAddress());
        httpRequest.setEntity((HttpEntity)new BasicHttpEntity());
        Object o = this.msgContext.getProperty("TRANSPORT_HEADERS");
        if (o != null && o instanceof Map) {
            Map headers = (Map)o;
            Iterator iter = headers.keySet().iterator();
            while (iter.hasNext()) {
                Object header = iter.next();
                Object value = headers.get(header);
                if (!(header instanceof String) || value == null || !(value instanceof String)) continue;
                httpRequest.setHeader((String)header, (String)value);
            }
        }
        if ((soapAction = this.msgContext.getSoapAction()) == null) {
            soapAction = this.msgContext.getWSAAction();
        }
        if (soapAction == null) {
            this.msgContext.getAxisOperation().getInputAction();
        }
        if (this.msgContext.isSOAP11() && soapAction != null && soapAction.length() > 0) {
            Header existingHeader = httpRequest.getFirstHeader("SOAPAction");
            if (existingHeader != null) {
                httpRequest.removeHeader(existingHeader);
            }
            httpRequest.setHeader("SOAPAction", soapAction);
        }
        httpRequest.setHeader("Content-Type", this.messageFormatter.getContentType(this.msgContext, this.format, this.msgContext.getSoapAction()));
        return httpRequest;
    }

    public ReadableByteChannel getSourceChannel() {
        log.debug((Object)"get source channel of the pipe on which the outgoing response is written");
        return this.pipe.source();
    }

    public void streamMessageContents() throws AxisFault {
        log.debug((Object)"start streaming outgoing http request");
        OutputStream out = Channels.newOutputStream(this.pipe.sink());
        this.messageFormatter.writeTo(this.msgContext, this.format, out, true);
        try {
            out.flush();
            out.close();
        }
        catch (IOException e) {
            this.handleException("Error closing outgoing message stream", e);
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

