/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.nhttp;

import org.apache.axis2.transport.nhttp.LoggingIOSession;
import org.apache.axis2.transport.nhttp.LoggingNHttpClientHandler;
import org.apache.http.HttpResponseFactory;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.params.HttpParams;

public class PlainClientIOEventDispatch
implements IOEventDispatch {
    private static final String NHTTP_CONN = "SYNAPSE.NHTTP_CONN";
    private final NHttpClientHandler handler;
    private final HttpParams params;

    public PlainClientIOEventDispatch(NHttpClientHandler handler, HttpParams params) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP client handler may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.handler = new LoggingNHttpClientHandler(handler);
        this.params = params;
    }

    public void connected(IOSession session) {
        DefaultNHttpClientConnection conn = new DefaultNHttpClientConnection((IOSession)new LoggingIOSession(session), (HttpResponseFactory)new DefaultHttpResponseFactory(), this.params);
        session.setAttribute(NHTTP_CONN, (Object)conn);
        Object attachment = session.getAttribute("http.session.attachment");
        this.handler.connected((NHttpClientConnection)conn, attachment);
    }

    public void disconnected(IOSession session) {
        DefaultNHttpClientConnection conn = (DefaultNHttpClientConnection)session.getAttribute(NHTTP_CONN);
        this.handler.closed((NHttpClientConnection)conn);
    }

    public void inputReady(IOSession session) {
        DefaultNHttpClientConnection conn = (DefaultNHttpClientConnection)session.getAttribute(NHTTP_CONN);
        conn.consumeInput(this.handler);
    }

    public void outputReady(IOSession session) {
        DefaultNHttpClientConnection conn = (DefaultNHttpClientConnection)session.getAttribute(NHTTP_CONN);
        conn.produceOutput(this.handler);
    }

    public void timeout(IOSession session) {
        DefaultNHttpClientConnection conn = (DefaultNHttpClientConnection)session.getAttribute(NHTTP_CONN);
        this.handler.timeout((NHttpClientConnection)conn);
    }
}

