/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import java.util.Random;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;

public class LoadbalanceFailoverClient {
    public static void main(String[] args) {
        String mode = System.getProperty("mode");
        if (mode != null) {
            if (mode.equalsIgnoreCase("session")) {
                new LoadbalanceFailoverClient().sessionfullClient();
            } else if (mode.equalsIgnoreCase("simple") || mode.equalsIgnoreCase("")) {
                new LoadbalanceFailoverClient().sessionlessClient();
            }
        } else {
            new LoadbalanceFailoverClient().sessionlessClient();
        }
    }

    private void sessionlessClient() {
        String synapsePort = "8080";
        int iterations = 100;
        boolean infinite = true;
        String pPort = System.getProperty("port");
        String pIterations = System.getProperty("i");
        if (pPort != null) {
            try {
                this.stringToInt(pPort);
                synapsePort = System.getProperty("port");
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (pIterations != null) {
            try {
                iterations = this.stringToInt(pIterations);
                if (iterations != -1) {
                    infinite = false;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement value = fac.createOMElement("Value", null);
        value.setText("Sample string");
        Options options = new Options();
        options.setTo(new EndpointReference("http://localhost:" + synapsePort));
        options.setAction("sampleOperation");
        try {
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)"client_repo", null);
            ServiceClient client = new ServiceClient(configContext, null);
            options.setTimeOutInMilliSeconds(10000000L);
            client.setOptions(options);
            client.engageModule("addressing");
            long i = 0L;
            while (i < (long)iterations || infinite) {
                OMElement responseElement = client.sendReceive(value);
                String response = responseElement.getText();
                System.out.println("Request: " + ++i + " ==> " + response);
            }
        }
        catch (AxisFault axisFault) {
            System.out.println(axisFault.getMessage());
        }
    }

    private void sessionfullClient() {
        String synapsePort = "8080";
        int iterations = 100;
        boolean infinite = true;
        String pPort = System.getProperty("port");
        String pIterations = System.getProperty("i");
        if (pPort != null) {
            try {
                this.stringToInt(pPort);
                synapsePort = System.getProperty("port");
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (pIterations != null) {
            try {
                iterations = this.stringToInt(pIterations);
                if (iterations != -1) {
                    infinite = false;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Options options = new Options();
        options.setTo(new EndpointReference("http://localhost:" + synapsePort));
        options.setAction("sampleOperation");
        options.setTimeOutInMilliSeconds(10000000L);
        try {
            SOAPEnvelope env1 = this.buildSoapEnvelope("c1", "v1");
            SOAPEnvelope env2 = this.buildSoapEnvelope("c2", "v1");
            SOAPEnvelope env3 = this.buildSoapEnvelope("c3", "v1");
            SOAPEnvelope[] envelopes = new SOAPEnvelope[]{env1, env2, env3};
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)"client_repo", null);
            ServiceClient client = new ServiceClient(configContext, null);
            client.setOptions(options);
            client.engageModule("addressing");
            int sessionNumber = 0;
            for (int i = 0; i < iterations || infinite; ++i) {
                MessageContext messageContext = new MessageContext();
                sessionNumber = this.getSessionTurn(envelopes.length);
                messageContext.setEnvelope(envelopes[sessionNumber]);
                OperationClient op = client.createClient(ServiceClient.ANON_OUT_IN_OP);
                op.addMessageContext(messageContext);
                op.execute(true);
                MessageContext responseContext = op.getMessageContext("In");
                SOAPEnvelope responseEnvelope = responseContext.getEnvelope();
                OMElement vElement = responseEnvelope.getBody().getFirstChildWithName(new QName("Value"));
                System.out.println("Request: " + i + " Session number: " + sessionNumber + " " + vElement.getText());
            }
        }
        catch (AxisFault axisFault) {
            System.out.println(axisFault.getMessage());
        }
    }

    private int getSessionTurn(int max) {
        Random random = new Random();
        return random.nextInt(max);
    }

    private SOAPEnvelope buildSoapEnvelope(String clientID, String value) {
        String targetEPR = "http://localhost:9000/soap/Service1";
        String opration = "sampleOperation";
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP12Factory();
        OMNamespace wsaNamespace = soapFactory.createOMNamespace("http://www.w3.org/2005/08/addressing", "wsa");
        SOAPEnvelope envelope = soapFactory.createSOAPEnvelope();
        SOAPHeader header = soapFactory.createSOAPHeader();
        envelope.addChild((OMNode)header);
        OMNamespace synNamespace = soapFactory.createOMNamespace("http://ws.apache.org/namespaces/synapse", "syn");
        OMElement clientIDElement = soapFactory.createOMElement("ClientID", synNamespace);
        clientIDElement.setText(clientID);
        header.addChild((OMNode)clientIDElement);
        SOAPBody body = soapFactory.createSOAPBody();
        envelope.addChild((OMNode)body);
        OMElement valueElement = soapFactory.createOMElement("Value", null);
        valueElement.setText(value);
        body.addChild((OMNode)valueElement);
        return envelope;
    }

    private int stringToInt(String stringNumber) {
        int number = new Integer(stringNumber);
        return number;
    }
}

