/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import java.io.File;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.transport.http.HttpTransportProperties;

public class JSONClient {
    public static void main(String[] args) {
        try {
            JSONClient.executeClient();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private static String getProperty(String name, String def) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = def;
        }
        return result;
    }

    public static void executeClient() throws Exception {
        ServiceClient serviceClient;
        Options options = new Options();
        ConfigurationContext configContext = null;
        String addUrl = JSONClient.getProperty("addurl", "http://localhost:8280/services/JSONProxy");
        String trpUrl = JSONClient.getProperty("trpurl", null);
        String prxUrl = JSONClient.getProperty("prxurl", null);
        String repo = JSONClient.getProperty("repository", "client_repo");
        String symbol = JSONClient.getProperty("symbol", "IBM");
        if (repo != null && !"null".equals(repo)) {
            configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repo, (String)(repo + File.separator + "conf" + File.separator + "axis2.xml"));
            serviceClient = new ServiceClient(configContext, null);
        } else {
            serviceClient = new ServiceClient();
        }
        if (trpUrl != null && !"null".equals(trpUrl)) {
            options.setProperty("TransportURL", (Object)trpUrl);
        }
        if (prxUrl != null && !"null".equals(prxUrl)) {
            HttpTransportProperties.ProxyProperties proxyProperties = new HttpTransportProperties.ProxyProperties();
            URL url = new URL(prxUrl);
            proxyProperties.setProxyName(url.getHost());
            proxyProperties.setProxyPort(url.getPort());
            proxyProperties.setUserName("");
            proxyProperties.setPassWord("");
            proxyProperties.setDomain("");
            options.setProperty("PROXY", (Object)proxyProperties);
        }
        serviceClient.engageModule("addressing");
        options.setTo(new EndpointReference(addUrl));
        options.setAction("urn:getQuote");
        options.setProperty("messageType", (Object)"application/json");
        serviceClient.setOptions(options);
        OMElement payload = AXIOMUtil.stringToOM((String)("<getQuote><request><symbol>" + symbol + "</symbol>" + "</request></getQuote>"));
        OMElement response = serviceClient.sendReceive(payload);
        if (!response.getLocalName().equals("getQuoteResponse")) {
            throw new Exception("Unexpected response : " + response);
        }
        OMElement last = response.getFirstElement().getFirstChildWithName(new QName("last"));
        System.out.println("Standard :: Stock price = $" + last.getText());
        Thread.sleep(1000L);
        if (configContext != null) {
            configContext.terminate();
        }
    }
}

