/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.commons;

import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.ui.commons.markup.html.form.preview.BinaryPreviewer;
import org.apache.syncope.client.ui.commons.markup.html.form.preview.DefaultPreviewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ClassUtils;

public class PreviewUtils {
    protected static final Logger LOG = LoggerFactory.getLogger(PreviewUtils.class);
    @Autowired
    private ClassPathScanImplementationLookup lookup;

    public BinaryPreviewer getPreviewer(String mimeType) {
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            return new DefaultPreviewer("previewer", mimeType);
        }
        Class<? extends BinaryPreviewer> previewer = this.lookup.getPreviewerClass(mimeType);
        try {
            return previewer == null ? new DefaultPreviewer("previewer", mimeType) : (BinaryPreviewer)ClassUtils.getConstructorIfAvailable(previewer, (Class[])new Class[]{String.class, String.class}).newInstance("previewer", mimeType);
        }
        catch (Exception e) {
            LOG.error("While getting BinaryPreviewer for {}", (Object)mimeType, (Object)e);
            return new DefaultPreviewer("previewer", mimeType);
        }
    }
}

