/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.init;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.ui.commons.annotations.BinaryPreview;
import org.apache.syncope.client.ui.commons.annotations.ExtPage;
import org.apache.syncope.client.ui.commons.annotations.Resource;
import org.apache.syncope.client.ui.commons.markup.html.form.preview.BinaryPreviewer;
import org.apache.syncope.client.ui.commons.panels.BaseSSOLoginFormPanel;
import org.apache.wicket.request.resource.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class ClassPathScanImplementationLookup
implements Serializable {
    private static final long serialVersionUID = -4944986595429290116L;
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathScanImplementationLookup.class);
    private static final String DEFAULT_BASE_PACKAGE = "org.apache.syncope";
    private List<Class<? extends BaseSSOLoginFormPanel>> ssoLoginFormPanels;
    private List<Class<? extends AbstractResource>> resources;
    private List<Class<? extends BinaryPreviewer>> previewers;
    private List<Class<? extends BasePage>> extPages;

    protected static String getBasePackage() {
        return DEFAULT_BASE_PACKAGE;
    }

    public void load() {
        this.previewers = new ArrayList<Class<? extends BinaryPreviewer>>();
        this.extPages = new ArrayList<Class<? extends BasePage>>();
        this.ssoLoginFormPanels = new ArrayList<Class<? extends BaseSSOLoginFormPanel>>();
        this.resources = new ArrayList<Class<? extends AbstractResource>>();
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AbstractResource.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BasePage.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BaseSSOLoginFormPanel.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BinaryPreviewer.class));
        scanner.findCandidateComponents(ClassPathScanImplementationLookup.getBasePackage()).forEach(bd -> {
            try {
                Class clazz = ClassUtils.resolveClassName((String)Objects.requireNonNull(bd.getBeanClassName()), (ClassLoader)ClassUtils.getDefaultClassLoader());
                boolean isAbstractClazz = Modifier.isAbstract(clazz.getModifiers());
                if (!isAbstractClazz) {
                    if (BasePage.class.isAssignableFrom(clazz)) {
                        if (clazz.isAnnotationPresent(ExtPage.class)) {
                            this.extPages.add(clazz);
                        } else {
                            LOG.error("Could not find annotation {} in {}, ignoring", (Object)ExtPage.class.getName(), (Object)clazz.getName());
                        }
                    } else if (AbstractResource.class.isAssignableFrom(clazz)) {
                        if (clazz.isAnnotationPresent(Resource.class)) {
                            this.resources.add(clazz);
                        } else {
                            LOG.error("Could not find annotation {} in {}, ignoring", (Object)Resource.class.getName(), (Object)clazz.getName());
                        }
                    } else if (BinaryPreviewer.class.isAssignableFrom(clazz)) {
                        this.previewers.add(clazz);
                    } else if (BaseSSOLoginFormPanel.class.isAssignableFrom(clazz)) {
                        this.ssoLoginFormPanels.add(clazz);
                    }
                }
            }
            catch (Throwable t) {
                LOG.warn("Could not inspect class {}", (Object)bd.getBeanClassName(), (Object)t);
            }
        });
        this.resources = Collections.unmodifiableList(this.resources);
        this.ssoLoginFormPanels = Collections.unmodifiableList(this.ssoLoginFormPanels);
        LOG.debug("Binary previewers found: {}", this.previewers);
        LOG.debug("Extension pages found: {}", this.extPages);
        LOG.debug("SSO Login pages found: {}", this.ssoLoginFormPanels);
        LOG.debug("Wicket Resources found: {}", this.resources);
    }

    public Class<? extends BinaryPreviewer> getPreviewerClass(String mimeType) {
        LOG.debug("Searching for previewer class for MIME type: {}", (Object)mimeType);
        Class<? extends BinaryPreviewer> previewer = null;
        for (Class<? extends BinaryPreviewer> candidate : this.previewers) {
            LOG.debug("Evaluating previewer class {} for MIME type {}", (Object)candidate.getName(), (Object)mimeType);
            if (!candidate.isAnnotationPresent(BinaryPreview.class) || !ArrayUtils.contains((Object[])candidate.getAnnotation(BinaryPreview.class).mimeTypes(), (Object)mimeType)) continue;
            LOG.debug("Found existing previewer for MIME type {}: {}", (Object)mimeType, (Object)candidate.getName());
            previewer = candidate;
        }
        return previewer;
    }

    public List<Class<? extends AbstractResource>> getResources() {
        return this.resources;
    }

    public List<Class<? extends BaseSSOLoginFormPanel>> getSSOLoginFormPanels() {
        return this.ssoLoginFormPanels;
    }

    public List<Class<? extends BasePage>> getExtPageClasses() {
        return this.extPages;
    }
}

