/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.lib;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.fasterxml.jackson.jaxrs.xml.JacksonXMLProvider;
import com.fasterxml.jackson.jaxrs.yaml.JacksonYAMLProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.BasicAuthenticationHandler;
import org.apache.syncope.client.lib.JWTAuthenticationHandler;
import org.apache.syncope.client.lib.NoAuthenticationHandler;
import org.apache.syncope.client.lib.RestClientExceptionMapper;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.jackson.SyncopeJsonMapper;
import org.apache.syncope.common.lib.jackson.SyncopeXmlMapper;
import org.apache.syncope.common.lib.jackson.SyncopeYAMLMapper;
import org.apache.syncope.common.rest.api.DateParamConverterProvider;
import org.apache.syncope.common.rest.api.RESTHeaders;

public class SyncopeClientFactoryBean {
    private JacksonJsonProvider jsonProvider;
    private JacksonXMLProvider xmlProvider;
    private JacksonYAMLProvider yamlProvider;
    private RestClientExceptionMapper exceptionMapper;
    private String address;
    private ContentType contentType;
    private String domain;
    private boolean useCompression;
    private TLSClientParameters tlsClientParameters;
    private JAXRSClientFactoryBean restClientFactoryBean;

    protected static JacksonJsonProvider defaultJsonProvider() {
        return new JacksonJsonProvider((ObjectMapper)new SyncopeJsonMapper());
    }

    protected static JacksonXMLProvider defaultXmlProvider() {
        return new JacksonXMLProvider((XmlMapper)new SyncopeXmlMapper());
    }

    protected static JacksonYAMLProvider defaultYamlProvider() {
        return new JacksonYAMLProvider((YAMLMapper)new SyncopeYAMLMapper());
    }

    protected static RestClientExceptionMapper defaultExceptionMapper() {
        return new RestClientExceptionMapper();
    }

    protected JAXRSClientFactoryBean defaultRestClientFactoryBean() {
        JAXRSClientFactoryBean defaultRestClientFactoryBean = new JAXRSClientFactoryBean();
        defaultRestClientFactoryBean.setHeaders(new HashMap());
        if (StringUtils.isBlank((CharSequence)this.address)) {
            throw new IllegalArgumentException("Property 'address' is missing");
        }
        defaultRestClientFactoryBean.setAddress(this.address);
        if (StringUtils.isNotBlank((CharSequence)this.domain)) {
            defaultRestClientFactoryBean.getHeaders().put("X-Syncope-Domain", List.of(this.domain));
        }
        defaultRestClientFactoryBean.setThreadSafe(true);
        defaultRestClientFactoryBean.setInheritHeaders(true);
        defaultRestClientFactoryBean.setFeatures(List.of(new LoggingFeature()));
        defaultRestClientFactoryBean.setProviders(List.of(new DateParamConverterProvider(), this.getJsonProvider(), this.getXmlProvider(), this.getYamlProvider(), this.getExceptionMapper()));
        return defaultRestClientFactoryBean;
    }

    public JacksonJsonProvider getJsonProvider() {
        return Optional.ofNullable(this.jsonProvider).orElseGet(SyncopeClientFactoryBean::defaultJsonProvider);
    }

    public void setJsonProvider(JacksonJsonProvider jsonProvider) {
        this.jsonProvider = jsonProvider;
    }

    public JacksonXMLProvider getXmlProvider() {
        return Optional.ofNullable(this.xmlProvider).orElseGet(SyncopeClientFactoryBean::defaultXmlProvider);
    }

    public void setXmlProvider(JacksonXMLProvider xmlProvider) {
        this.xmlProvider = xmlProvider;
    }

    public JacksonYAMLProvider getYamlProvider() {
        return Optional.ofNullable(this.yamlProvider).orElseGet(SyncopeClientFactoryBean::defaultYamlProvider);
    }

    public void setYamlProvider(JacksonYAMLProvider yamlProvider) {
        this.yamlProvider = yamlProvider;
    }

    public RestClientExceptionMapper getExceptionMapper() {
        return Optional.ofNullable(this.exceptionMapper).orElseGet(SyncopeClientFactoryBean::defaultExceptionMapper);
    }

    public SyncopeClientFactoryBean setExceptionMapper(RestClientExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public SyncopeClientFactoryBean setAddress(String address) {
        this.address = address;
        return this;
    }

    public ContentType getContentType() {
        return Optional.ofNullable(this.contentType).orElse(ContentType.JSON);
    }

    public SyncopeClientFactoryBean setContentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public SyncopeClientFactoryBean setContentType(String contentType) {
        this.contentType = ContentType.fromString(contentType);
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public SyncopeClientFactoryBean setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public SyncopeClientFactoryBean setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
        return this;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public SyncopeClientFactoryBean setTlsClientParameters(TLSClientParameters tlsClientParameters) {
        this.tlsClientParameters = tlsClientParameters;
        return this;
    }

    public TLSClientParameters getTlsClientParameters() {
        return this.tlsClientParameters;
    }

    public JAXRSClientFactoryBean getRestClientFactoryBean() {
        return Optional.ofNullable(this.restClientFactoryBean).orElseGet(this::defaultRestClientFactoryBean);
    }

    public SyncopeClientFactoryBean setRestClientFactoryBean(JAXRSClientFactoryBean restClientFactoryBean) {
        this.restClientFactoryBean = restClientFactoryBean;
        return this;
    }

    public SyncopeClient create() {
        return this.create(new NoAuthenticationHandler());
    }

    public SyncopeClient create(String username, String password) {
        return this.create(new BasicAuthenticationHandler(username, password));
    }

    public SyncopeClient create(String jwt) {
        return this.create(new JWTAuthenticationHandler(jwt));
    }

    public SyncopeClient create(AuthenticationHandler handler) {
        return new SyncopeClient(this.getContentType().getMediaType(), this.getRestClientFactoryBean(), this.getExceptionMapper(), handler, this.useCompression, this.tlsClientParameters);
    }

    public static enum ContentType {
        JSON(MediaType.APPLICATION_JSON_TYPE),
        YAML(RESTHeaders.APPLICATION_YAML_TYPE),
        XML(MediaType.APPLICATION_XML_TYPE);

        private final MediaType mediaType;

        private ContentType(MediaType mediaType) {
            this.mediaType = mediaType;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public static ContentType fromString(String value) {
            return XML.getMediaType().toString().equalsIgnoreCase(value) ? XML : (YAML.getMediaType().toString().equalsIgnoreCase(value) ? YAML : JSON);
        }
    }
}

