/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.audit;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.JsonDiffPanel;
import org.apache.syncope.common.lib.log.AuditEntry;
import org.apache.syncope.common.lib.to.AbstractAnnotatedBean;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuditHistoryDetails<T extends Serializable>
extends MultilevelPanel.SecondLevel {
    private static final long serialVersionUID = -7400543686272100483L;
    private static final Logger LOG = LoggerFactory.getLogger(AuditHistoryDetails.class);
    private static final ObjectMapper MAPPER = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().nodeFactory((JsonNodeFactory)new SortingNodeFactory())).build()).registerModule((Module)new SimpleModule().addSerializer((JsonSerializer)new SortedSetJsonSerializer(AuditHistoryDetails.cast(Set.class))));

    private static <T> Class<T> cast(Class<?> aClass) {
        return aClass;
    }

    public AuditHistoryDetails(final MultilevelPanel mlp, final AuditEntry selected, EntityTO currentEntity, String auditRestoreEntitlement, PageReference pageRef) {
        AuditEntry current = new AuditEntry();
        if (currentEntity instanceof AbstractAnnotatedBean) {
            current.setWho(((AbstractAnnotatedBean)currentEntity).getCreator());
            current.setDate(((AbstractAnnotatedBean)currentEntity).getCreationDate());
        } else {
            current.setWho(SyncopeConsoleSession.get().getSelfTO().getUsername());
            current.setDate(new Date());
        }
        try {
            current.setBefore(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)currentEntity));
        }
        catch (JsonProcessingException e) {
            LOG.error("While serializing current entity", (Throwable)e);
            throw new WicketRuntimeException((Throwable)e);
        }
        this.add(new Component[]{new Label("current", (Serializable)((Object)this.getString("current")))});
        this.add(new Component[]{new Label("previous", (Serializable)((Object)this.getString("previous")))});
        Class<?> reference = currentEntity.getClass();
        this.add(new Component[]{new JsonDiffPanel(null, (IModel)this.toJSON(current, reference), (IModel)this.toJSON(selected, reference), null){
            private static final long serialVersionUID = 2087989787864619493L;

            @Override
            public void onSubmit(AjaxRequestTarget target) {
                this.modal.close((IPartialPageRequestHandler)target);
            }
        }});
        AjaxLink<Void> restore = new AjaxLink<Void>("restore"){
            private static final long serialVersionUID = -817438685948164787L;

            public void onClick(AjaxRequestTarget target) {
                try {
                    String json = selected.getBefore() == null ? MAPPER.readTree(selected.getOutput()).get("entity").toPrettyString() : selected.getBefore();
                    AuditHistoryDetails.this.restore(json, target);
                    mlp.prev(target);
                }
                catch (JsonProcessingException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)restore, (Action)ENABLE, (String)auditRestoreEntitlement);
        this.add(new Component[]{restore});
    }

    protected abstract void restore(String var1, AjaxRequestTarget var2);

    private Model<String> toJSON(AuditEntry auditEntry, Class<T> reference) {
        try {
            String content = auditEntry.getBefore() == null ? MAPPER.readTree(auditEntry.getOutput()).get("entity").toPrettyString() : auditEntry.getBefore();
            Serializable entity = (Serializable)MAPPER.reader().with(StreamReadFeature.STRICT_DUPLICATE_DETECTION).readValue(content, reference);
            if (entity instanceof UserTO) {
                UserTO userTO = (UserTO)entity;
                userTO.setPassword(null);
                userTO.setSecurityAnswer(null);
            }
            return Model.of((Serializable)((Object)MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)entity)));
        }
        catch (Exception e) {
            LOG.error("While (de)serializing entity {}", (Object)auditEntry, (Object)e);
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    private static class SortedSetJsonSerializer
    extends StdSerializer<Set<?>> {
        private static final long serialVersionUID = 3849059774309L;

        SortedSetJsonSerializer(Class<Set<?>> clazz) {
            super(clazz);
        }

        public void serialize(Set<?> set, JsonGenerator gen, SerializerProvider sp) throws IOException {
            if (set == null) {
                gen.writeNull();
                return;
            }
            gen.writeStartArray();
            if (!set.isEmpty()) {
                Set<?> sorted = set;
                if (!SortedSet.class.isAssignableFrom(set.getClass())) {
                    Object item = set.iterator().next();
                    if (Comparable.class.isAssignableFrom(item.getClass())) {
                        sorted = new TreeSet(set);
                    } else {
                        LOG.debug("Cannot sort items of type {}", item.getClass());
                    }
                }
                for (Object item : sorted) {
                    gen.writeObject(item);
                }
            }
            gen.writeEndArray();
        }
    }

    private static class SortingNodeFactory
    extends JsonNodeFactory {
        private static final long serialVersionUID = 1870252010670L;

        private SortingNodeFactory() {
        }

        public ObjectNode objectNode() {
            return new ObjectNode((JsonNodeFactory)this, new TreeMap());
        }
    }
}

