/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.init;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MIMETypesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MIMETypesLoader.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private Map<String, String> mimeTypesMap;
    private List<String> mimeTypes;

    public void load() {
        this.mimeTypesMap = new HashMap<String, String>();
        try {
            JsonNode jsonNode = MAPPER.readTree(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/MIMETypes.json")));
            for (JsonNode node : jsonNode) {
                JsonNode type = node.path("name");
                JsonNode ext = node.path("extension");
                if (type.isMissingNode()) continue;
                this.mimeTypesMap.put(type.asText(), ext.isMissingNode() ? "" : ext.asText());
            }
            this.mimeTypesMap = Collections.unmodifiableMap(this.mimeTypesMap);
            LOG.debug("MIME types loaded: {}", this.mimeTypesMap);
            this.mimeTypes = new ArrayList<String>(this.mimeTypesMap.keySet());
            Collections.sort(this.mimeTypes);
            this.mimeTypes = Collections.unmodifiableList(this.mimeTypes);
        }
        catch (Exception e) {
            LOG.error("Error reading file MIMETypes from resources", (Throwable)e);
        }
    }

    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    public String getFileExt(String mimeType) {
        return this.mimeTypesMap.get(mimeType);
    }
}

