/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.commons.SchemaUtils;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDateFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.BinaryFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.EncryptedFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class ParametersDetailsPanel
extends Panel {
    private static final long serialVersionUID = 7708288006191496557L;
    private final SchemaRestClient schemaRestClient = new SchemaRestClient();
    private final AjaxTextFieldPanel schema;

    public ParametersDetailsPanel(String id, AttrTO attrTO) {
        super(id);
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        Form form = new Form("parametersForm");
        form.setMarkupId("parametersForm");
        form.setOutputMarkupId(true);
        form.setModel((IModel)new CompoundPropertyModel((Object)attrTO));
        container.add(new Component[]{form});
        this.schema = new AjaxTextFieldPanel("schema", this.getString("schema"), (IModel<String>)new PropertyModel((Object)attrTO, "schema"));
        this.schema.setEnabled(false);
        form.add(new Component[]{this.schema});
        form.add(new Component[]{this.getFieldPanel("panel", attrTO)});
    }

    private Panel getFieldPanel(String id, AttrTO attrTO) {
        FieldPanel panel;
        String valueHeaderName = this.getString("values");
        PlainSchemaTO plainSchema = (PlainSchemaTO)this.schemaRestClient.read(SchemaType.PLAIN, attrTO.getSchema());
        switch (plainSchema.getType()) {
            case Date: {
                String datePattern;
                String string = datePattern = plainSchema.getConversionPattern() == null ? "yyyy-MM-dd'T'HH:mm:ssZ" : plainSchema.getConversionPattern();
                if (StringUtils.containsIgnoreCase((CharSequence)datePattern, (CharSequence)"H")) {
                    panel = new AjaxDateTimeFieldPanel("panel", plainSchema.getKey(), (IModel<Date>)new Model(), datePattern);
                    break;
                }
                panel = new AjaxDateFieldPanel("panel", plainSchema.getKey(), (IModel<Date>)new Model(), datePattern);
                break;
            }
            case Boolean: {
                panel = new AjaxDropDownChoicePanel(id, valueHeaderName, new Model(), false);
                ((AjaxDropDownChoicePanel)panel).setChoices(Arrays.asList("true", "false"));
                if (!attrTO.getValues().isEmpty()) {
                    ((AjaxDropDownChoicePanel)panel).setChoiceRenderer(new IChoiceRenderer<String>(){
                        private static final long serialVersionUID = -3724971416312135885L;

                        public String getDisplayValue(String value) {
                            return value;
                        }

                        public String getIdValue(String value, int i) {
                            return value;
                        }

                        public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                            return id;
                        }
                    });
                }
                ((AjaxDropDownChoicePanel)panel).setNullValid(false);
                break;
            }
            case Enum: {
                panel = new AjaxDropDownChoicePanel(id, valueHeaderName, new Model(), false);
                ((AjaxDropDownChoicePanel)panel).setChoices(SchemaUtils.getEnumeratedValues(plainSchema));
                if (!attrTO.getValues().isEmpty()) {
                    ((AjaxDropDownChoicePanel)panel).setChoiceRenderer(new IChoiceRenderer<String>(){
                        private static final long serialVersionUID = -3724971416312135885L;

                        public String getDisplayValue(String value) {
                            return value;
                        }

                        public String getIdValue(String value, int i) {
                            return value;
                        }

                        public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                            return id;
                        }
                    });
                }
                ((AjaxDropDownChoicePanel)panel).setNullValid("false".equalsIgnoreCase(plainSchema.getMandatoryCondition()));
                break;
            }
            case Long: {
                panel = new AjaxSpinnerFieldPanel.Builder<Long>().build(id, valueHeaderName, Long.class, (IModel<Long>)new Model());
                break;
            }
            case Double: {
                panel = new AjaxSpinnerFieldPanel.Builder<Double>().build(id, valueHeaderName, Double.class, (IModel<Double>)new Model());
                break;
            }
            case Binary: {
                panel = new BinaryFieldPanel(id, valueHeaderName, (IModel<String>)new Model(), plainSchema.getMimeType(), (String)this.schema.getModelObject());
                break;
            }
            case Encrypted: {
                panel = "ENCRYPTED_DECODE_CONVERSION_PATTERN".equals(plainSchema.getConversionPattern()) ? new AjaxTextFieldPanel(id, valueHeaderName, (IModel<String>)new Model(), false) : new EncryptedFieldPanel(id, valueHeaderName, (IModel<String>)new Model(), true);
                break;
            }
            default: {
                panel = new AjaxTextFieldPanel(id, valueHeaderName, (IModel<String>)new Model(), false);
            }
        }
        if (plainSchema.isMultivalue()) {
            return new MultiFieldPanel.Builder(new PropertyModel((Object)attrTO, "values")).build(id, valueHeaderName, panel);
        }
        panel.setNewModel(attrTO.getValues());
        panel.setRequired("true".equalsIgnoreCase(plainSchema.getMandatoryCondition()));
        return panel;
    }
}

