/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.audit.AuditHistoryModal;
import org.apache.syncope.client.console.commons.ResourceDataProvider;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.ConnObjects;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.status.ResourceStatusModal;
import org.apache.syncope.client.console.tasks.PropagationTasks;
import org.apache.syncope.client.console.tasks.PullTasks;
import org.apache.syncope.client.console.tasks.PushTasks;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceProvisionPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceWizardBuilder;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class ResourceDirectoryPanel
extends DirectoryPanel<Serializable, Serializable, ResourceDataProvider, ResourceRestClient> {
    private static final long serialVersionUID = -5223129956783782225L;
    protected String keyword;
    protected final ConnectorRestClient connectorRestClient = new ConnectorRestClient();
    protected final BaseModal<Serializable> propTaskModal;
    protected final BaseModal<Serializable> schedTaskModal;
    protected final BaseModal<Serializable> provisionModal;
    protected final BaseModal<Serializable> historyModal;

    protected ResourceDirectoryPanel(String id, Builder builder) {
        super(id, builder);
        if (SyncopeConsoleSession.get().owns("RESOURCE_CREATE", new String[0])) {
            MetaDataRoleAuthorizationStrategy.authorizeAll((Component)this.addAjaxLink, (Action)RENDER);
        } else {
            MetaDataRoleAuthorizationStrategy.unauthorizeAll((Component)this.addAjaxLink, (Action)RENDER);
        }
        this.setShowResultPage(false);
        this.modal.size(Modal.Size.Large);
        this.initResultTable();
        this.restClient = builder.restClient;
        this.propTaskModal = new BaseModal("outer");
        this.propTaskModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.propTaskModal});
        this.schedTaskModal = new BaseModal<Serializable>("outer"){
            private static final long serialVersionUID = -6165152045136958913L;

            protected void onConfigure() {
                super.onConfigure();
                this.setFooterVisible(false);
            }
        };
        this.schedTaskModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.schedTaskModal});
        this.provisionModal = new BaseModal("outer");
        this.provisionModal.size(Modal.Size.Large);
        this.provisionModal.addSubmitButton();
        this.addOuterObject(new Component[]{this.provisionModal});
        this.historyModal = new BaseModal("outer");
        this.historyModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.historyModal});
    }

    @Override
    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof ResourceSearchEvent) {
            ResourceSearchEvent payload = (ResourceSearchEvent)event.getPayload();
            AjaxRequestTarget target = payload.getTarget();
            if (StringUtils.isNotEmpty((CharSequence)payload.getKeyword())) {
                this.keyword = payload.getKeyword().toLowerCase();
            }
            this.updateResultTable(target);
        } else {
            super.onEvent(event);
        }
    }

    @Override
    protected ResourceDataProvider dataProvider() {
        this.dataProvider = new ResourceDataProvider(this.rows, this.pageRef, this.keyword);
        return (ResourceDataProvider)this.dataProvider;
    }

    public ResourceDataProvider getDataProvider() {
        return (ResourceDataProvider)this.dataProvider;
    }

    @Override
    protected String paginatorRowsKey() {
        return "parameters.paginator.rows";
    }

    @Override
    protected List<IColumn<Serializable, String>> getColumns() {
        ArrayList<IColumn<Serializable, String>> columns = new ArrayList<IColumn<Serializable, String>>();
        columns.add((IColumn<Serializable, String>)new PropertyColumn((IModel)new ResourceModel("key"), (Object)"keySortParam", "key"));
        columns.add((IColumn<Serializable, String>)new PropertyColumn((IModel)new ResourceModel("connectorDisplayName"), (Object)"connectorDisplayNameSortParam", "connectorDisplayName"));
        return columns;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.singletonList(ActionLink.ActionType.DELETE);
    }

    @Override
    public ActionsPanel<Serializable> getActions(final IModel<Serializable> model) {
        ActionsPanel<Serializable> panel = super.getActions(model);
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -7220222653598674870L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ResourceTO resource = ((ResourceRestClient)ResourceDirectoryPanel.this.restClient).read(((ResourceTO)model.getObject()).getKey());
                ConnInstanceTO connInstance = ResourceDirectoryPanel.this.connectorRestClient.read(resource.getConnector());
                CompoundPropertyModel model2 = new CompoundPropertyModel((Object)resource);
                ResourceDirectoryPanel.this.modal.setFormModel(model2);
                target.add(new Component[]{ResourceDirectoryPanel.this.modal.setContent(new ResourceWizardBuilder(resource, ResourceDirectoryPanel.this.pageRef).build("content", SyncopeConsoleSession.get().owns("RESOURCE_UPDATE", connInstance.getAdminRealm()) ? AjaxWizard.Mode.EDIT : AjaxWizard.Mode.READONLY))});
                ResourceDirectoryPanel.this.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(ResourceDirectoryPanel.this.getString("resource.edit"), ((ResourceTO)model2.getObject()).getKey()))));
                ResourceDirectoryPanel.this.modal.show(true);
            }
        }, ActionLink.ActionType.EDIT, String.format("%s,%s", "RESOURCE_READ", "RESOURCE_UPDATE"));
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -6467344504797047254L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ResourceTO resource = ((ResourceRestClient)ResourceDirectoryPanel.this.restClient).read(((ResourceTO)model.getObject()).getKey());
                ConnInstanceTO connInstance = ResourceDirectoryPanel.this.connectorRestClient.read(resource.getConnector());
                if (SyncopeConsoleSession.get().owns("RESOURCE_UPDATE", connInstance.getAdminRealm())) {
                    ResourceDirectoryPanel.this.provisionModal.addSubmitButton();
                } else {
                    ResourceDirectoryPanel.this.provisionModal.removeSubmitButton();
                }
                CompoundPropertyModel model2 = new CompoundPropertyModel((Object)resource);
                ResourceDirectoryPanel.this.provisionModal.setFormModel((Serializable)model2);
                target.add(new Component[]{ResourceDirectoryPanel.this.provisionModal.setContent(new ResourceProvisionPanel(ResourceDirectoryPanel.this.provisionModal, resource, connInstance.getAdminRealm(), ResourceDirectoryPanel.this.pageRef))});
                ResourceDirectoryPanel.this.provisionModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(ResourceDirectoryPanel.this.getString("resource.edit"), ((ResourceTO)model2.getObject()).getKey()))));
                ResourceDirectoryPanel.this.provisionModal.show(true);
            }
        }, ActionLink.ActionType.MAPPING, String.format("%s,%s", "RESOURCE_READ", "RESOURCE_UPDATE"));
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -1448897313753684142L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ResourceTO resource = ((ResourceRestClient)ResourceDirectoryPanel.this.restClient).read(((ResourceTO)model.getObject()).getKey());
                target.add(new Component[]{ResourceDirectoryPanel.this.propTaskModal.setContent(new ConnObjects(resource, ResourceDirectoryPanel.this.pageRef))});
                ResourceDirectoryPanel.this.propTaskModal.header((IModel)new StringResourceModel("resource.explore.list", (IModel)Model.of((Serializable)((Serializable)model.getObject()))));
                ResourceDirectoryPanel.this.propTaskModal.show(true);
            }
        }, ActionLink.ActionType.EXPLORE_RESOURCE, "RESOURCE_LIST_CONNOBJECT");
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = 4800323783814856195L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                target.add(new Component[]{ResourceDirectoryPanel.this.propTaskModal.setContent(new PropagationTasks(ResourceDirectoryPanel.this.propTaskModal, ((ResourceTO)model.getObject()).getKey(), ResourceDirectoryPanel.this.pageRef))});
                ResourceDirectoryPanel.this.propTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(ResourceDirectoryPanel.this.getString("task.propagation.list"), ((ResourceTO)model.getObject()).getKey()))));
                ResourceDirectoryPanel.this.propTaskModal.show(true);
            }
        }, ActionLink.ActionType.PROPAGATION_TASKS, "TASK_LIST");
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -4699610013584898667L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                target.add(new Component[]{ResourceDirectoryPanel.this.schedTaskModal.setContent(new PullTasks(ResourceDirectoryPanel.this.schedTaskModal, ResourceDirectoryPanel.this.pageRef, ((ResourceTO)model.getObject()).getKey()))});
                ResourceDirectoryPanel.this.schedTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(ResourceDirectoryPanel.this.getString("task.pull.list"), ((ResourceTO)model.getObject()).getKey()))));
                ResourceDirectoryPanel.this.schedTaskModal.show(true);
            }
        }, ActionLink.ActionType.PULL_TASKS, "TASK_LIST");
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = 2042227976628604686L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                target.add(new Component[]{ResourceDirectoryPanel.this.schedTaskModal.setContent(new PushTasks(ResourceDirectoryPanel.this.schedTaskModal, ResourceDirectoryPanel.this.pageRef, ((ResourceTO)model.getObject()).getKey()))});
                ResourceDirectoryPanel.this.schedTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(ResourceDirectoryPanel.this.getString("task.push.list"), ((ResourceTO)model.getObject()).getKey()))));
                ResourceDirectoryPanel.this.schedTaskModal.show(true);
            }
        }, ActionLink.ActionType.PUSH_TASKS, "TASK_LIST");
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -5962061673680621813L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ResourceTO modelObject = ((ResourceRestClient)ResourceDirectoryPanel.this.restClient).read(((ResourceTO)model.getObject()).getKey());
                target.add(new Component[]{ResourceDirectoryPanel.this.propTaskModal.setContent(new ResourceStatusModal(ResourceDirectoryPanel.this.propTaskModal, ResourceDirectoryPanel.this.pageRef, modelObject))});
                ResourceDirectoryPanel.this.propTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(ResourceDirectoryPanel.this.getString("resource.reconciliation"), ((ResourceTO)model.getObject()).getKey()))));
                ResourceDirectoryPanel.this.propTaskModal.show(true);
            }
        }, ActionLink.ActionType.RECONCILIATION_RESOURCE, "USER_UPDATE");
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -5432034353017728766L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ResourceTO modelObject = ((ResourceRestClient)ResourceDirectoryPanel.this.restClient).read(((ResourceTO)model.getObject()).getKey());
                target.add(new Component[]{ResourceDirectoryPanel.this.historyModal.setContent(new AuditHistoryModal<ResourceTO>(ResourceDirectoryPanel.this.historyModal, AuditElements.EventCategoryType.LOGIC, "ResourceLogic", modelObject, "RESOURCE_UPDATE", ResourceDirectoryPanel.this.pageRef){
                    private static final long serialVersionUID = -3712506022627033811L;

                    @Override
                    protected void restore(String json, AjaxRequestTarget target) {
                        try {
                            ResourceTO updated = (ResourceTO)DirectoryPanel.MAPPER.readValue(json, ResourceTO.class);
                            ((ResourceRestClient)ResourceDirectoryPanel.this.restClient).update(updated);
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                        }
                        catch (Exception e) {
                            DirectoryPanel.LOG.error("While restoring resource {}", (Object)((ResourceTO)model.getObject()).getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)ResourceDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                ResourceDirectoryPanel.this.historyModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(ResourceDirectoryPanel.this.getString("resource.menu.history"), ((ResourceTO)model.getObject()).getKey()))));
                ResourceDirectoryPanel.this.historyModal.show(true);
            }
        }, ActionLink.ActionType.VIEW_AUDIT_HISTORY, String.format("%s,%s", "RESOURCE_READ", "AUDIT_LIST"));
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = 7019899256702149874L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                try {
                    ResourceTO resource = ((ResourceRestClient)ResourceDirectoryPanel.this.restClient).read(((ResourceTO)model.getObject()).getKey());
                    resource.setKey("Copy of " + resource.getKey());
                    if (resource.getOrgUnit() != null) {
                        resource.getOrgUnit().setKey(null);
                        resource.getOrgUnit().getItems().forEach(item -> item.setKey(null));
                    }
                    resource.getProvisions().forEach(provision -> {
                        provision.setKey(null);
                        if (provision.getMapping() != null) {
                            provision.getMapping().getItems().forEach(item -> item.setKey(null));
                            provision.getMapping().getLinkingItems().clear();
                        }
                        provision.getVirSchemas().clear();
                    });
                    target.add(new Component[]{ResourceDirectoryPanel.this.modal.setContent(new ResourceWizardBuilder(resource, ResourceDirectoryPanel.this.pageRef).build("content", AjaxWizard.Mode.CREATE))});
                    ResourceDirectoryPanel.this.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(ResourceDirectoryPanel.this.getString("resource.clone"), resource.getKey()))));
                    ResourceDirectoryPanel.this.modal.show(true);
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While cloning resource {}", (Object)((ResourceTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)ResourceDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.CLONE, "RESOURCE_CREATE");
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = 4516186028545701573L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                try {
                    ((ResourceRestClient)ResourceDirectoryPanel.this.restClient).delete(((ResourceTO)model.getObject()).getKey());
                    target.appendJavaScript((CharSequence)String.format("jsPlumb.remove('%s');", ((ResourceTO)model.getObject()).getKey()));
                    SyncopeConsoleSession.get().success((Serializable)((Object)ResourceDirectoryPanel.this.getString("operation_succeeded")));
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting resource {}", (Object)((ResourceTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)ResourceDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "RESOURCE_DELETE", true);
        return panel;
    }

    public static class Builder
    extends DirectoryPanel.Builder<Serializable, Serializable, ResourceRestClient> {
        private static final long serialVersionUID = -1391308721262593468L;

        public Builder(PageReference pageRef) {
            super(new ResourceRestClient(), pageRef);
            this.setShowResultPage(false);
        }

        @Override
        protected WizardMgtPanel<Serializable> newInstance(String id, boolean wizardInModal) {
            return new ResourceDirectoryPanel(id, this);
        }
    }

    public static class ResourceSearchEvent
    implements Serializable {
        private static final long serialVersionUID = 213974502541311941L;
        protected final AjaxRequestTarget target;
        protected final String keyword;

        public ResourceSearchEvent(AjaxRequestTarget target, String keyword) {
            this.target = target;
            this.keyword = keyword;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public String getKeyword() {
            return this.keyword;
        }
    }
}

