/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.policies;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.policies.PolicyRuleWizardBuilder;
import org.apache.syncope.client.console.policies.PolicyRuleWrapper;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.policy.ComposablePolicy;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.policy.RuleConf;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public class PolicyRuleDirectoryPanel<T extends PolicyTO>
extends DirectoryPanel<PolicyRuleWrapper, PolicyRuleWrapper, DirectoryDataProvider<PolicyRuleWrapper>, PolicyRestClient>
implements ModalPanel {
    private static final long serialVersionUID = 4984337552918213290L;
    private final BaseModal<T> baseModal;
    private final PolicyType type;
    private final ImplementationType implementationType;
    private final String policy;

    protected PolicyRuleDirectoryPanel(BaseModal<T> baseModal, String policy, PolicyType type, PageReference pageRef) {
        super("content", pageRef, false);
        this.disableCheckBoxes();
        this.baseModal = baseModal;
        this.type = type;
        this.implementationType = type == PolicyType.ACCOUNT ? ImplementationType.ACCOUNT_RULE : ImplementationType.PASSWORD_RULE;
        this.policy = policy;
        this.restClient = new PolicyRestClient();
        this.enableExitButton();
        this.addNewItemPanelBuilder(new PolicyRuleWizardBuilder(policy, type, new PolicyRuleWrapper(true), pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"POLICY_UPDATE");
        this.initResultTable();
    }

    @Override
    protected List<IColumn<PolicyRuleWrapper, String>> getColumns() {
        ArrayList<IColumn<PolicyRuleWrapper, String>> columns = new ArrayList<IColumn<PolicyRuleWrapper, String>>();
        columns.add((IColumn<PolicyRuleWrapper, String>)new PropertyColumn((IModel)new StringResourceModel("rule", (Component)this), (Object)"implementationKey", "implementationKey"));
        columns.add((IColumn<PolicyRuleWrapper, String>)new AbstractColumn<PolicyRuleWrapper, String>((IModel)new StringResourceModel("configuration", (Component)this)){
            private static final long serialVersionUID = -4008579357070833846L;

            public void populateItem(Item<ICellPopulator<PolicyRuleWrapper>> cellItem, String componentId, IModel<PolicyRuleWrapper> rowModel) {
                if (((PolicyRuleWrapper)rowModel.getObject()).getConf() == null) {
                    cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)""))});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)((PolicyRuleWrapper)rowModel.getObject()).getConf().getClass().getName()))});
                }
            }
        });
        return columns;
    }

    @Override
    public ActionsPanel<PolicyRuleWrapper> getActions(final IModel<PolicyRuleWrapper> model) {
        ActionsPanel<PolicyRuleWrapper> panel = super.getActions(model);
        panel.add(new ActionLink<PolicyRuleWrapper>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, PolicyRuleWrapper ignore) {
                PolicyRuleDirectoryPanel.this.getTogglePanel().close(target);
                if (((PolicyRuleWrapper)model.getObject()).getConf() == null) {
                    SyncopeConsoleSession.get().info((Serializable)((Object)PolicyRuleDirectoryPanel.this.getString("noConf")));
                    ((BasePage)PolicyRuleDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                } else {
                    PolicyRuleDirectoryPanel.this.send((IEventSink)PolicyRuleDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<Serializable>((Serializable)model.getObject(), target));
                }
            }
        }, ActionLink.ActionType.EDIT, "POLICY_UPDATE");
        panel.add(new ActionLink<PolicyRuleWrapper>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, PolicyRuleWrapper ignore) {
                RuleConf rule = ((PolicyRuleWrapper)model.getObject()).getConf();
                try {
                    Object actual = ((PolicyRestClient)PolicyRuleDirectoryPanel.this.restClient).getPolicy(PolicyRuleDirectoryPanel.this.type, PolicyRuleDirectoryPanel.this.policy);
                    if (actual instanceof ComposablePolicy) {
                        ((ComposablePolicy)actual).getRules().remove(((PolicyRuleWrapper)model.getObject()).getImplementationKey());
                        ((PolicyRestClient)PolicyRuleDirectoryPanel.this.restClient).updatePolicy(PolicyRuleDirectoryPanel.this.type, actual);
                        SyncopeConsoleSession.get().success((Serializable)((Object)PolicyRuleDirectoryPanel.this.getString("operation_succeeded")));
                        PolicyRuleDirectoryPanel.this.customActionOnFinishCallback(target);
                    }
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting {}", (Object)rule.getName(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)PolicyRuleDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "POLICY_DELETE", true);
        return panel;
    }

    @Override
    public ActionsPanel<Serializable> getHeader(String componentId) {
        ActionsPanel<Serializable> panel = new ActionsPanel<Serializable>(componentId, null);
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                if (target != null) {
                    PolicyRuleDirectoryPanel.this.customActionOnFinishCallback(target);
                }
            }
        }, ActionLink.ActionType.RELOAD, "POLICY_LIST").hideLabel();
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.emptyList();
    }

    @Override
    protected PolicyRuleDataProvider dataProvider() {
        return new PolicyRuleDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "policy.rules.paginator.rows";
    }

    @Override
    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof WizardMgtPanel.ExitEvent && this.modal != null) {
            AjaxRequestTarget target = ((WizardMgtPanel.ExitEvent)WizardMgtPanel.ExitEvent.class.cast(event.getPayload())).getTarget();
            this.baseModal.show(false);
            this.baseModal.close((IPartialPageRequestHandler)target);
        }
    }

    protected class PolicyRuleDataProvider
    extends DirectoryDataProvider<PolicyRuleWrapper> {
        private static final long serialVersionUID = 4725679400450513556L;
        private final ImplementationRestClient implementationClient;
        private final SortableDataProviderComparator<PolicyRuleWrapper> comparator;

        public PolicyRuleDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.implementationClient = new ImplementationRestClient();
            this.setSort("implementationKey", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<PolicyRuleWrapper>(this);
        }

        private List<PolicyRuleWrapper> getPolicyRuleWrappers(ComposablePolicy policy) {
            return policy.getRules().stream().map(rule -> {
                ImplementationTO implementation = this.implementationClient.read(PolicyRuleDirectoryPanel.this.implementationType, (String)rule);
                PolicyRuleWrapper wrapper = new PolicyRuleWrapper(false).setImplementationKey(implementation.getKey()).setImplementationEngine(implementation.getEngine());
                if (implementation.getEngine() == ImplementationEngine.JAVA) {
                    try {
                        RuleConf ruleConf = (RuleConf)MAPPER.readValue(implementation.getBody(), RuleConf.class);
                        wrapper.setConf(ruleConf);
                    }
                    catch (Exception e) {
                        LOG.error("During deserialization", (Throwable)e);
                    }
                }
                return wrapper;
            }).collect(Collectors.toList());
        }

        public Iterator<PolicyRuleWrapper> iterator(long first, long count) {
            Object actual = ((PolicyRestClient)PolicyRuleDirectoryPanel.this.restClient).getPolicy(PolicyRuleDirectoryPanel.this.type, PolicyRuleDirectoryPanel.this.policy);
            List rules = actual instanceof ComposablePolicy ? this.getPolicyRuleWrappers((ComposablePolicy)actual) : Collections.emptyList();
            Collections.sort(rules, this.comparator);
            return rules.subList((int)first, (int)(first + count)).iterator();
        }

        public long size() {
            Object actual = ((PolicyRestClient)PolicyRuleDirectoryPanel.this.restClient).getPolicy(PolicyRuleDirectoryPanel.this.type, PolicyRuleDirectoryPanel.this.policy);
            return actual instanceof ComposablePolicy ? (long)this.getPolicyRuleWrappers((ComposablePolicy)actual).size() : 0L;
        }

        public IModel<PolicyRuleWrapper> model(PolicyRuleWrapper object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

