/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.to.GroupTO;

public class GroupWrapper
extends AnyWrapper<GroupTO> {
    private static final long serialVersionUID = 8058288034211558376L;
    private GroupTO previousGroupTO;
    private List<SearchClause> uDynClauses;
    private Map<String, List<SearchClause>> aDynClauses;

    public GroupWrapper(GroupTO groupTO) {
        this(null, groupTO);
    }

    public GroupWrapper(GroupTO previousGroupTO, GroupTO groupTO) {
        super(groupTO);
        this.previousGroupTO = previousGroupTO;
        this.getUDynClauses();
        this.getADynClauses();
    }

    public GroupTO getPreviousGroupTO() {
        return this.previousGroupTO;
    }

    public final List<SearchClause> getUDynClauses() {
        if (this.uDynClauses == null) {
            this.uDynClauses = SearchUtils.getSearchClauses(((GroupTO)this.anyTO).getUDynMembershipCond());
        }
        return this.uDynClauses;
    }

    public void setUDynClauses(List<SearchClause> uDynClauses) {
        this.uDynClauses = uDynClauses;
    }

    public final Map<String, List<SearchClause>> getADynClauses() {
        if (this.aDynClauses == null) {
            this.aDynClauses = SearchUtils.getSearchClauses(((GroupTO)this.anyTO).getADynMembershipConds());
        }
        return this.aDynClauses;
    }

    public void setADynClauses(Map<String, List<SearchClause>> aDynClauses) {
        this.aDynClauses = aDynClauses;
    }

    public String getUDynMembershipCond() {
        return CollectionUtils.isEmpty(this.uDynClauses) ? null : SearchUtils.buildFIQL(this.uDynClauses, SyncopeClient.getUserSearchConditionBuilder());
    }

    public Map<String, String> getADynMembershipConds() {
        HashMap<String, String> res = new HashMap<String, String>();
        if (this.aDynClauses != null && !this.aDynClauses.isEmpty()) {
            this.aDynClauses.entrySet().stream().filter(entry -> CollectionUtils.isNotEmpty((Collection)((Collection)entry.getValue()))).forEach(entry -> {
                String fiql = SearchUtils.buildFIQL((List)entry.getValue(), SyncopeClient.getAnyObjectSearchConditionBuilder((String)((String)entry.getKey())));
                if (fiql != null) {
                    res.put((String)entry.getKey(), fiql);
                }
            });
        }
        return res;
    }

    public GroupTO fillDynamicConditions() {
        ((GroupTO)this.anyTO).setUDynMembershipCond(this.getUDynMembershipCond());
        ((GroupTO)this.anyTO).getADynMembershipConds().clear();
        ((GroupTO)this.anyTO).getADynMembershipConds().putAll(this.getADynMembershipConds());
        return (GroupTO)this.anyTO;
    }
}

