/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.audit.AuditHistoryModal;
import org.apache.syncope.client.console.commons.ConnectorDataProvider;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.resources.ConnectorWizardBuilder;
import org.apache.syncope.client.console.wizards.resources.ResourceWizardBuilder;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public class ConnectorDirectoryPanel
extends DirectoryPanel<Serializable, Serializable, ConnectorDataProvider, ConnectorRestClient> {
    private static final long serialVersionUID = 2041468935602350821L;
    private String keyword;

    protected ConnectorDirectoryPanel(String id, Builder builder) {
        super(id, builder);
        if (SyncopeConsoleSession.get().owns("CONNECTOR_CREATE", new String[0])) {
            MetaDataRoleAuthorizationStrategy.authorizeAll((Component)this.addAjaxLink, (Action)RENDER);
        } else {
            MetaDataRoleAuthorizationStrategy.unauthorizeAll((Component)this.addAjaxLink, (Action)RENDER);
        }
        this.setShowResultPage(false);
        this.modal.size(Modal.Size.Large);
        this.initResultTable();
        this.restClient = builder.restClient;
    }

    @Override
    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof ConnectorSearchEvent) {
            ConnectorSearchEvent payload = (ConnectorSearchEvent)event.getPayload();
            AjaxRequestTarget target = payload.getTarget();
            if (StringUtils.isNotBlank((CharSequence)payload.getKeyword())) {
                this.keyword = payload.getKeyword().toLowerCase();
            }
            this.updateResultTable(target);
        } else {
            super.onEvent(event);
        }
    }

    @Override
    protected ConnectorDataProvider dataProvider() {
        this.dataProvider = new ConnectorDataProvider(this.rows, this.pageRef, this.keyword);
        return (ConnectorDataProvider)this.dataProvider;
    }

    public ConnectorDataProvider getDataProvider() {
        return (ConnectorDataProvider)this.dataProvider;
    }

    @Override
    protected String paginatorRowsKey() {
        return "parameters.paginator.rows";
    }

    @Override
    protected List<IColumn<Serializable, String>> getColumns() {
        ArrayList<IColumn<Serializable, String>> columns = new ArrayList<IColumn<Serializable, String>>();
        columns.add((IColumn<Serializable, String>)new PropertyColumn((IModel)new ResourceModel("displayName"), (Object)"displayNameSortParam", "displayName"));
        columns.add((IColumn<Serializable, String>)new PropertyColumn((IModel)new ResourceModel("connectorName"), (Object)"connectorNameSortParam", "connectorName"));
        return columns;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.singletonList(ActionLink.ActionType.DELETE);
    }

    @Override
    public ActionsPanel<Serializable> getActions(final IModel<Serializable> model) {
        ActionsPanel<Serializable> panel = super.getActions(model);
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = 8345646188740279483L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ResourceTO modelObject = new ResourceTO();
                modelObject.setConnector(((ConnInstanceTO)model.getObject()).getKey());
                modelObject.setConnectorDisplayName(((ConnInstanceTO)model.getObject()).getDisplayName());
                CompoundPropertyModel model2 = new CompoundPropertyModel((Object)modelObject);
                ConnectorDirectoryPanel.this.modal.setFormModel((Serializable)model2.getObject());
                target.add(new Component[]{ConnectorDirectoryPanel.this.modal.setContent(new ResourceWizardBuilder(modelObject, ConnectorDirectoryPanel.this.pageRef).build("content", AjaxWizard.Mode.CREATE))});
                ConnectorDirectoryPanel.this.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(ConnectorDirectoryPanel.this.getString("resource.new"), ((ResourceTO)model2.getObject()).getKey()))));
                ConnectorDirectoryPanel.this.modal.show(true);
                target.add(new Component[]{ConnectorDirectoryPanel.this.modal});
            }
        }, ActionLink.ActionType.CREATE_RESOURCE, String.format("%s", "RESOURCE_CREATE"));
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = 8200500789152854321L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ConnInstanceTO connInstance = ((ConnectorRestClient)ConnectorDirectoryPanel.this.restClient).read(((ConnInstanceTO)model.getObject()).getKey());
                CompoundPropertyModel model2 = new CompoundPropertyModel((Object)connInstance);
                ConnectorDirectoryPanel.this.modal.setFormModel(model2);
                target.add(new Component[]{ConnectorDirectoryPanel.this.modal.setContent(new ConnectorWizardBuilder(connInstance, ConnectorDirectoryPanel.this.pageRef).build("content", SyncopeConsoleSession.get().owns("CONNECTOR_UPDATE", connInstance.getAdminRealm()) ? AjaxWizard.Mode.EDIT : AjaxWizard.Mode.READONLY))});
                ConnectorDirectoryPanel.this.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(ConnectorDirectoryPanel.this.getString("connector.edit"), connInstance.getDisplayName()))));
                ConnectorDirectoryPanel.this.modal.show(true);
            }
        }, ActionLink.ActionType.EDIT, String.format("%s,%s", "CONNECTOR_READ", "CONNECTOR_UPDATE"));
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = 1085863437941911947L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ConnInstanceTO modelObject = ((ConnectorRestClient)ConnectorDirectoryPanel.this.restClient).read(((ConnInstanceTO)model.getObject()).getKey());
                target.add(new Component[]{ConnectorDirectoryPanel.this.altDefaultModal.setContent(new AuditHistoryModal<ConnInstanceTO>(ConnectorDirectoryPanel.this.altDefaultModal, AuditElements.EventCategoryType.LOGIC, "ConnectorLogic", modelObject, "CONNECTOR_UPDATE", ConnectorDirectoryPanel.this.pageRef){
                    private static final long serialVersionUID = -3225348282675513648L;

                    @Override
                    protected void restore(String json, AjaxRequestTarget target) {
                        try {
                            ConnInstanceTO updated = (ConnInstanceTO)DirectoryPanel.MAPPER.readValue(json, ConnInstanceTO.class);
                            ((ConnectorRestClient)ConnectorDirectoryPanel.this.restClient).update(updated);
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                        }
                        catch (Exception e) {
                            DirectoryPanel.LOG.error("While restoring connector {}", (Object)((ConnInstanceTO)model.getObject()).getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)ConnectorDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                ConnectorDirectoryPanel.this.altDefaultModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(ConnectorDirectoryPanel.this.getString("connector.menu.history"), ((ConnInstanceTO)model.getObject()).getDisplayName()))));
                ConnectorDirectoryPanel.this.altDefaultModal.show(true);
            }
        }, ActionLink.ActionType.VIEW_AUDIT_HISTORY, String.format("%s,%s", "CONNECTOR_READ", "AUDIT_LIST"));
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -1544718936080799146L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                try {
                    ((ConnectorRestClient)ConnectorDirectoryPanel.this.restClient).delete(((ConnInstanceTO)model.getObject()).getKey());
                    target.appendJavaScript((CharSequence)String.format("jsPlumb.remove('%s');", ((ConnInstanceTO)model.getObject()).getKey()));
                    SyncopeConsoleSession.get().success((Serializable)((Object)ConnectorDirectoryPanel.this.getString("operation_succeeded")));
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting resource {}", (Object)((ConnInstanceTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)ConnectorDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "CONNECTOR_DELETE", true);
        return panel;
    }

    public static class Builder
    extends DirectoryPanel.Builder<Serializable, Serializable, ConnectorRestClient> {
        private static final long serialVersionUID = 6128427903964630093L;

        public Builder(PageReference pageRef) {
            super(new ConnectorRestClient(), pageRef);
            this.setShowResultPage(false);
        }

        @Override
        protected WizardMgtPanel<Serializable> newInstance(String id, boolean wizardInModal) {
            return new ConnectorDirectoryPanel(id, this);
        }
    }

    public static class ConnectorSearchEvent
    implements Serializable {
        private static final long serialVersionUID = -282052400565266028L;
        private final AjaxRequestTarget target;
        private final String keyword;

        public ConnectorSearchEvent(AjaxRequestTarget target, String keyword) {
            this.target = target;
            this.keyword = keyword;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public String getKeyword() {
            return this.keyword;
        }
    }
}

