/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.client.console.rest.SyncopeRestClient;
import org.apache.syncope.client.console.wicket.ajax.IndicatorAjaxTimerBehavior;
import org.apache.syncope.client.console.widgets.AnyByRealmWidget;
import org.apache.syncope.client.console.widgets.CompletenessWidget;
import org.apache.syncope.client.console.widgets.LoadWidget;
import org.apache.syncope.client.console.widgets.NumberWidget;
import org.apache.syncope.client.console.widgets.UsersByStatusWidget;
import org.apache.syncope.common.lib.info.NumbersInfo;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.util.time.Duration;

public class DashboardOverviewPanel
extends Panel {
    private static final long serialVersionUID = 5989039374050260225L;
    private final NumberWidget totalUsers;
    private final NumberWidget totalGroups;
    private final NumberWidget totalAny1OrRoles;
    private final NumberWidget totalAny2OrResources;
    private final UsersByStatusWidget usersByStatus;
    private final CompletenessWidget completeness;
    private final AnyByRealmWidget anyByRealm;
    private final LoadWidget load;
    private final SyncopeRestClient restClient = new SyncopeRestClient();

    public DashboardOverviewPanel(String id) {
        super(id);
        NumbersInfo numbers = this.restClient.numbers();
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.totalUsers = new NumberWidget("totalUsers", "bg-yellow", numbers.getTotalUsers(), this.getString("users"), "ion ion-person");
        container.add(new Component[]{this.totalUsers});
        this.totalGroups = new NumberWidget("totalGroups", "bg-red", numbers.getTotalGroups(), this.getString("groups"), "ion ion-person-stalker");
        container.add(new Component[]{this.totalGroups});
        Triple<Integer, String, String> built = this.buildTotalAny1OrRoles(numbers);
        this.totalAny1OrRoles = new NumberWidget("totalAny1OrRoles", "bg-green", (Integer)built.getLeft(), (String)built.getMiddle(), (String)built.getRight());
        container.add(new Component[]{this.totalAny1OrRoles});
        built = this.buildTotalAny2OrResources(numbers);
        this.totalAny2OrResources = new NumberWidget("totalAny2OrResources", "bg-aqua", (Integer)built.getLeft(), (String)built.getMiddle(), (String)built.getRight());
        container.add(new Component[]{this.totalAny2OrResources});
        this.usersByStatus = new UsersByStatusWidget("usersByStatus", numbers.getUsersByStatus());
        container.add(new Component[]{this.usersByStatus});
        this.completeness = new CompletenessWidget("completeness", numbers.getConfCompleteness());
        container.add(new Component[]{this.completeness});
        this.anyByRealm = new AnyByRealmWidget("anyByRealm", numbers.getUsersByRealm(), numbers.getGroupsByRealm(), numbers.getAnyType1(), numbers.getAny1ByRealm(), numbers.getAnyType2(), numbers.getAny2ByRealm());
        container.add(new Component[]{this.anyByRealm});
        this.load = new LoadWidget("load", this.restClient.system());
        container.add(new Component[]{this.load});
        container.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.seconds((int)60)){
            private static final long serialVersionUID = -4426283634345968585L;

            protected void onTimer(AjaxRequestTarget target) {
                NumbersInfo numbers = DashboardOverviewPanel.this.restClient.numbers();
                if (DashboardOverviewPanel.this.totalUsers.refresh(numbers.getTotalUsers())) {
                    target.add(new Component[]{DashboardOverviewPanel.this.totalUsers});
                }
                if (DashboardOverviewPanel.this.totalGroups.refresh(numbers.getTotalGroups())) {
                    target.add(new Component[]{DashboardOverviewPanel.this.totalGroups});
                }
                Triple updatedBuild = DashboardOverviewPanel.this.buildTotalAny1OrRoles(numbers);
                if (DashboardOverviewPanel.this.totalAny1OrRoles.refresh((Integer)updatedBuild.getLeft())) {
                    target.add(new Component[]{DashboardOverviewPanel.this.totalAny1OrRoles});
                }
                updatedBuild = DashboardOverviewPanel.this.buildTotalAny2OrResources(numbers);
                if (DashboardOverviewPanel.this.totalAny2OrResources.refresh((Integer)updatedBuild.getLeft())) {
                    target.add(new Component[]{DashboardOverviewPanel.this.totalAny2OrResources});
                }
                if (DashboardOverviewPanel.this.usersByStatus.refresh(numbers.getUsersByStatus())) {
                    target.add(new Component[]{DashboardOverviewPanel.this.usersByStatus});
                }
                if (DashboardOverviewPanel.this.completeness.refresh(numbers.getConfCompleteness())) {
                    target.add(new Component[]{DashboardOverviewPanel.this.completeness});
                }
                if (DashboardOverviewPanel.this.anyByRealm.refresh(numbers.getUsersByRealm(), numbers.getGroupsByRealm(), numbers.getAnyType1(), numbers.getAny1ByRealm(), numbers.getAnyType2(), numbers.getAny2ByRealm())) {
                    target.add(new Component[]{DashboardOverviewPanel.this.anyByRealm});
                }
                DashboardOverviewPanel.this.load.refresh(DashboardOverviewPanel.this.restClient.system());
                target.add(new Component[]{DashboardOverviewPanel.this.load});
            }
        }});
    }

    private Triple<Integer, String, String> buildTotalAny1OrRoles(NumbersInfo numbers) {
        String icon;
        String label;
        int number;
        if (numbers.getAnyType1() == null) {
            number = numbers.getTotalRoles();
            label = this.getString("roles");
            icon = "fa fa-users";
        } else {
            number = numbers.getTotalAny1();
            label = numbers.getAnyType1();
            icon = "ion ion-gear-a";
        }
        return Triple.of((Object)number, (Object)label, (Object)icon);
    }

    private Triple<Integer, String, String> buildTotalAny2OrResources(NumbersInfo numbers) {
        String icon;
        String label;
        int number;
        if (numbers.getAnyType2() == null) {
            number = numbers.getTotalResources();
            label = this.getString("resources");
            icon = "fa fa-database";
        } else {
            number = numbers.getTotalAny2();
            label = numbers.getAnyType2();
            icon = "ion ion-gear-a";
        }
        return Triple.of((Object)number, (Object)label, (Object)icon);
    }
}

