/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.form;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.wicket.markup.html.form.Action;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.IndicatingOnConfirmAjaxLink;
import org.apache.syncope.client.console.wicket.markup.html.link.VeilPopupSettings;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public final class ActionPanel<T extends Serializable>
extends Panel {
    private static final long serialVersionUID = 322966537010107771L;
    private final Label actionIcon;
    private final Label actionLabel;
    private boolean disableIndicator = false;
    private final Action<T> action;

    public ActionPanel(IModel<T> model, Action<T> action) {
        this("action", model, action);
    }

    public ActionPanel(String componentId, IModel<T> model, final Action<T> action) {
        super(componentId);
        IndicatingAjaxLink<Void> actionLink;
        boolean enabled;
        this.setOutputMarkupId(true);
        this.action = action;
        final Serializable obj = model == null ? null : (Serializable)model.getObject();
        if (action.getLink() == null || action.getType() == ActionLink.ActionType.NOT_FOUND) {
            enabled = true;
            actionLink = new IndicatingAjaxLink<Void>("action"){
                private static final long serialVersionUID = -7978723352517770644L;

                public boolean isEnabled() {
                    return false;
                }

                public void onClick(AjaxRequestTarget target) {
                }
            };
        } else if (action.getType() == ActionLink.ActionType.EXTERNAL_EDITOR) {
            enabled = action.getLink().isEnabled(obj);
            actionLink = new BookmarkablePageLink("action", action.getLink().getPageClass(), action.getLink().getPageParameters()).setPopupSettings(new VeilPopupSettings().setHeight(600).setWidth(800));
        } else {
            enabled = action.getLink().isEnabled(obj);
            IndicatingAjaxLink<Void> indicatingAjaxLink = action.isOnConfirm() ? new IndicatingOnConfirmAjaxLink<Void>("action", StringUtils.isNotBlank((CharSequence)action.getLink().getConfirmMessage()) ? action.getLink().getConfirmMessage() : "confirmDelete", enabled){
                private static final long serialVersionUID = -7978723352517770644L;

                public void onClick(AjaxRequestTarget target) {
                    ActionPanel.this.beforeOnClick(target);
                    action.getLink().onClick(target, obj);
                }

                @Override
                public String getAjaxIndicatorMarkupId() {
                    return ActionPanel.this.disableIndicator || !action.getLink().isIndicatorEnabled() ? "" : "veil";
                }
            } : (actionLink = new IndicatingAjaxLink<Void>("action"){
                private static final long serialVersionUID = -7978723352517770644L;

                public void onClick(AjaxRequestTarget target) {
                    ActionPanel.this.beforeOnClick(target);
                    action.getLink().onClick(target, obj);
                }

                public String getAjaxIndicatorMarkupId() {
                    return ActionPanel.this.disableIndicator || !action.getLink().isIndicatorEnabled() ? "" : "veil";
                }
            });
        }
        if (SyncopeConsoleSession.get().owns(action.getEntitlements(), action.getRealms())) {
            MetaDataRoleAuthorizationStrategy.authorizeAll((Component)actionLink, (org.apache.wicket.authorization.Action)RENDER);
        } else {
            MetaDataRoleAuthorizationStrategy.unauthorizeAll((Component)actionLink, (org.apache.wicket.authorization.Action)RENDER);
        }
        actionLink.setVisible(enabled);
        this.actionIcon = new Label("actionIcon", (Serializable)((Object)""));
        actionLink.add(new Component[]{this.actionIcon});
        String clazz = action.getType().name().toLowerCase() + ".class";
        this.actionIcon.add(new Behavior[]{new AttributeModifier("class", (IModel)new ResourceModel(clazz, clazz))});
        String title = action.getType().name().toLowerCase() + ".title";
        ResourceModel titleModel = new ResourceModel(title, title);
        this.actionIcon.add(new Behavior[]{new AttributeModifier("title", (IModel)titleModel)});
        String alt = action.getType().name().toLowerCase() + ".alt";
        this.actionIcon.add(new Behavior[]{new AttributeModifier("alt", (IModel)new ResourceModel(alt, alt))});
        this.actionLabel = new Label("label", (IModel)titleModel);
        actionLink.add(new Component[]{this.actionLabel});
        this.add(new Component[]{actionLink});
        this.actionLabel.setVisible(action.isVisibleLabel());
        if (action.getLabel() != null) {
            this.actionLabel.setDefaultModel(action.getLabel());
        }
        if (action.getTitle() != null) {
            this.actionIcon.add(new Behavior[]{new AttributeModifier("title", action.getTitle())});
        }
        if (action.getAlt() != null) {
            this.actionIcon.add(new Behavior[]{new AttributeModifier("alt", action.getAlt())});
        }
        if (action.getIcon() != null) {
            this.actionIcon.add(new Behavior[]{new AttributeModifier("class", action.getIcon())});
        }
        this.disableIndicator = !action.hasIndicator();
    }

    protected void beforeOnClick(AjaxRequestTarget target) {
        switch (this.action.getType()) {
            case DELETE: 
            case CREATE: 
            case MEMBERS: 
            case MAPPING: 
            case SET_LATEST_SYNC_TOKEN: 
            case REMOVE_SYNC_TOKEN: 
            case EDIT_APPROVAL: 
            case CLAIM: {
                this.send((IEventSink)this, Broadcast.BUBBLE, new ActionLinksTogglePanel.ActionLinkToggleCloseEventPayload(target));
                break;
            }
        }
    }
}

