/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AlertWidget<T extends Serializable>
extends Panel {
    private static final long serialVersionUID = 7667120094526529934L;
    protected static final Logger LOG = LoggerFactory.getLogger(AlertWidget.class);
    protected static final int MAX_SIZE = 5;
    protected final Label linkAlertsNumber;
    protected final Label headerAlertsNumber;
    protected final WebMarkupContainer latestAlertsList;
    protected IModel<List<T>> latestAlerts = this.getLatestAlerts();

    public AlertWidget(String id) {
        super(id);
        this.setOutputMarkupId(true);
        LoadableDetachableModel<Integer> size = new LoadableDetachableModel<Integer>(){
            private static final long serialVersionUID = 7474274077691068779L;

            protected Integer load() {
                return AlertWidget.this.getLatestAlertsSize();
            }
        };
        LoadableDetachableModel items = new LoadableDetachableModel<List<T>>(){
            private static final long serialVersionUID = 7474274077691068779L;

            protected List<T> load() {
                List latest;
                return latest.subList(0, (latest = (List)AlertWidget.this.latestAlerts.getObject()).size() <= 5 ? latest.size() : 5);
            }
        };
        this.add(new Component[]{this.getIcon("icon")});
        this.linkAlertsNumber = new Label("alerts", (IModel)size){
            private static final long serialVersionUID = 4755868673082976208L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (Integer.parseInt(this.getDefaultModelObject().toString()) > 0) {
                    tag.put("class", (CharSequence)"label label-danger");
                } else {
                    tag.put("class", (CharSequence)"label label-info");
                }
            }
        };
        this.add(new Component[]{this.linkAlertsNumber.setOutputMarkupId(true)});
        this.headerAlertsNumber = new Label("number", (IModel)size);
        this.headerAlertsNumber.setOutputMarkupId(true);
        this.add(new Component[]{this.headerAlertsNumber});
        this.add(new Component[]{this.getEventsLink("alertsLink")});
        this.latestAlertsList = new WebMarkupContainer("latestAlertsList");
        this.latestAlertsList.setOutputMarkupId(true);
        this.add(new Component[]{this.latestAlertsList});
    }

    protected int getLatestAlertsSize() {
        return ((List)this.latestAlerts.getObject()).size();
    }

    protected abstract IModel<List<T>> getLatestAlerts();

    protected abstract AbstractLink getEventsLink(String var1);

    protected abstract Icon getIcon(String var1);

    public static class AlertLink<T>
    extends Panel {
        private static final long serialVersionUID = -6011939604125512766L;

        public AlertLink(String id, T alert) {
            super(id);
            this.add(new Component[]{new Label("alert", (Serializable)((Object)alert.toString()))});
        }
    }
}

