/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.DelegationRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.client.console.wizards.UserSelectionWizardStep;
import org.apache.syncope.common.lib.to.DelegationTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;

public class DelegationWizardBuilder
extends AjaxWizardBuilder<DelegationTO> {
    private static final long serialVersionUID = 16656970898539L;
    private final DelegationRestClient restClient = new DelegationRestClient();
    private final UserRestClient userRestClient = new UserRestClient();

    public DelegationWizardBuilder(DelegationTO defaultItem, PageReference pageRef) {
        super(defaultItem, pageRef);
    }

    @Override
    protected Serializable onApplyInternal(DelegationTO modelObject) {
        if (this.getOriginalItem() == null || StringUtils.isBlank((CharSequence)((DelegationTO)this.getOriginalItem()).getKey())) {
            this.restClient.create(modelObject);
        } else {
            this.restClient.update(modelObject);
        }
        return null;
    }

    @Override
    protected WizardModel buildModelSteps(DelegationTO modelObject, WizardModel wizardModel) {
        if (this.getOriginalItem() == null || StringUtils.isBlank((CharSequence)((DelegationTO)this.getOriginalItem()).getKey()) && SyncopeConsoleSession.get().owns("USER_SEARCH", new String[0]) && SyncopeConsoleSession.get().owns("DELEGATION_CREATE", new String[0])) {
            wizardModel.add((IWizardStep)new UserSelectionWizardStep((IModel<String>)new ResourceModel("delegating"), (IModel<String>)new PropertyModel((Object)modelObject, "delegating"), this.pageRef));
            wizardModel.add((IWizardStep)new UserSelectionWizardStep((IModel<String>)new ResourceModel("delegated"), (IModel<String>)new PropertyModel((Object)modelObject, "delegated"), this.pageRef));
        } else {
            wizardModel.add((IWizardStep)new Users(modelObject));
        }
        wizardModel.add((IWizardStep)new StartEnd(modelObject));
        wizardModel.add((IWizardStep)new Roles(modelObject));
        return wizardModel;
    }

    private class Roles
    extends WizardStep
    implements WizardModel.ICondition {
        private static final long serialVersionUID = 16957451737824L;
        private final List<String> allRoles = new ArrayList<String>();
        private final DelegationTO modelObject;

        Roles(DelegationTO modelObject) {
            this.modelObject = modelObject;
            this.setTitleModel((IModel)new ResourceModel("roles"));
            this.add(new Component[]{new AjaxPalettePanel.Builder().withFilter().setAllowOrder(true).build("roles", (IModel<List<String>>)new PropertyModel((Object)modelObject, "roles"), new AjaxPalettePanel.Builder.Query<String>(){
                private static final long serialVersionUID = 3900199363626636719L;

                @Override
                public List<String> execute(String filter) {
                    if (StringUtils.isEmpty((CharSequence)filter) || "*".equals(filter)) {
                        return Roles.this.allRoles.size() > 30 ? Roles.this.allRoles.subList(0, 30) : Roles.this.allRoles;
                    }
                    return Roles.this.allRoles.stream().filter(role -> StringUtils.containsIgnoreCase((CharSequence)role, (CharSequence)filter)).collect(Collectors.toList());
                }
            }).hideLabel().setOutputMarkupId(true)});
        }

        public boolean evaluate() {
            if (this.modelObject.getDelegating() != null) {
                this.allRoles.clear();
                if (SyncopeConsoleSession.get().owns("USER_READ", new String[0])) {
                    this.allRoles.addAll(((UserTO)DelegationWizardBuilder.this.userRestClient.read(this.modelObject.getDelegating())).getRoles());
                } else if (SyncopeConsoleSession.get().getSelfTO().getKey().equals(this.modelObject.getDelegating())) {
                    this.allRoles.addAll(SyncopeConsoleSession.get().getSelfTO().getRoles());
                }
            }
            return true;
        }
    }

    private static class StartEnd
    extends WizardStep {
        private static final long serialVersionUID = 16957451737824L;

        StartEnd(DelegationTO modelObject) {
            this.setTitleModel((IModel)new ResourceModel("validity"));
            this.add(new Component[]{new AjaxDateTimeFieldPanel("start", "start", (IModel<Date>)new PropertyModel((Object)modelObject, "start"), "yyyy-MM-dd'T'HH:mm:ssZ").addRequiredLabel()});
            this.add(new Component[]{new AjaxDateTimeFieldPanel("end", "end", (IModel<Date>)new PropertyModel((Object)modelObject, "end"), "yyyy-MM-dd'T'HH:mm:ssZ")});
        }
    }

    private class Users
    extends WizardStep {
        private static final long serialVersionUID = 33859341441696L;

        Users(DelegationTO modelObject) {
            boolean isSelfOnly;
            boolean isNew;
            this.setTitleModel((IModel)new ResourceModel("users"));
            PropertyModel delegating = new PropertyModel((Object)modelObject, "delegating");
            PropertyModel delegated = new PropertyModel((Object)modelObject, "delegated");
            boolean bl = isNew = DelegationWizardBuilder.this.getOriginalItem() == null || StringUtils.isBlank((CharSequence)((DelegationTO)DelegationWizardBuilder.this.getOriginalItem()).getKey());
            if (!isNew) {
                if (SyncopeConsoleSession.get().owns("USER_READ", new String[0])) {
                    delegating = Model.of((Serializable)((Object)((UserTO)DelegationWizardBuilder.this.userRestClient.read((String)delegating.getObject())).getUsername()));
                    delegated = Model.of((Serializable)((Object)((UserTO)DelegationWizardBuilder.this.userRestClient.read((String)delegated.getObject())).getUsername()));
                } else {
                    if (SyncopeConsoleSession.get().getSelfTO().getKey().equals(delegating.getObject())) {
                        delegating = Model.of((Serializable)((Object)SyncopeConsoleSession.get().getSelfTO().getUsername()));
                    }
                    if (SyncopeConsoleSession.get().getSelfTO().getKey().equals(delegated.getObject())) {
                        delegated = Model.of((Serializable)((Object)SyncopeConsoleSession.get().getSelfTO().getUsername()));
                    }
                }
            }
            boolean bl2 = isSelfOnly = !SyncopeConsoleSession.get().owns("DELEGATION_CREATE", new String[0]);
            if (isSelfOnly) {
                modelObject.setDelegating(SyncopeConsoleSession.get().getSelfTO().getUsername());
            }
            this.add(new Component[]{new AjaxTextFieldPanel("delegating", "delegating", (IModel<String>)delegating, false).addRequiredLabel().setEnabled(isNew && !isSelfOnly)});
            this.add(new Component[]{new AjaxTextFieldPanel("delegated", "delegated", (IModel<String>)delegated, false).addRequiredLabel().setEnabled(isNew)});
        }
    }
}

