/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.panels.search.AnyObjectSearchPanel;
import org.apache.syncope.client.console.panels.search.MapOfListModel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.console.wizards.any.GroupWrapper;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class DynamicMemberships
extends WizardStep {
    private static final long serialVersionUID = 855618618337931784L;
    private final AnyTypeRestClient anyTypeRestClient = new AnyTypeRestClient();

    public DynamicMemberships(final GroupWrapper groupWrapper) {
        LoadableDetachableModel<List<AnyTypeTO>> types = new LoadableDetachableModel<List<AnyTypeTO>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<AnyTypeTO> load() {
                return DynamicMemberships.this.anyTypeRestClient.listAnyTypes().stream().filter(type -> AnyTypeKind.USER != type.getKind() && AnyTypeKind.GROUP != type.getKind()).collect(Collectors.toList());
            }
        };
        this.add(new Component[]{new Accordion("uDynMembershipCond", Collections.singletonList(new AbstractTab((IModel)new ResourceModel("uDynMembershipCond", "Dynamic USER Membership Conditions")){
            private static final long serialVersionUID = 1037272333056449378L;

            public Panel getPanel(String panelId) {
                return new UserSearchPanel.Builder((IModel<List<SearchClause>>)new PropertyModel((Object)groupWrapper, "uDynClauses")).required(true).build(panelId);
            }
        }), (IModel<Integer>)Model.of((Serializable)Integer.valueOf(StringUtils.isBlank((CharSequence)groupWrapper.getUDynMembershipCond()) ? -1 : 0))).setOutputMarkupId(true)});
        this.add(new Component[]{new ListView<AnyTypeTO>("aDynMembershipCond", (IModel)types){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<AnyTypeTO> item) {
                final String key = ((AnyTypeTO)item.getModelObject()).getKey();
                item.add(new Component[]{new Accordion("aDynMembershipCond", Collections.singletonList(new AbstractTab((IModel)new StringResourceModel("aDynMembershipCond", (Component)this, (IModel)new Model((Serializable)item.getModelObject()))){
                    private static final long serialVersionUID = 1037272333056449378L;

                    public Panel getPanel(String panelId) {
                        return new AnyObjectSearchPanel.Builder(key, (IModel<List<SearchClause>>)new MapOfListModel(groupWrapper, "aDynClauses", key)).required(false).build(panelId);
                    }
                }), (IModel<Integer>)Model.of((Serializable)Integer.valueOf(StringUtils.isBlank((CharSequence)groupWrapper.getADynMembershipConds().get(key)) ? -1 : 0))).setOutputMarkupId(true)});
            }
        }});
    }
}

