/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.client.console.commons.status.ConnObjectWrapper;
import org.apache.syncope.client.console.commons.status.Status;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.commons.status.StatusUtils;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.panels.PropagationErrorPanel;
import org.apache.syncope.client.console.panels.RemoteObjectPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wizards.any.ConnObjectPanel;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ReconStatus;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPanel
extends Panel {
    private static final long serialVersionUID = -4013796607157549641L;
    private static final Logger LOG = LoggerFactory.getLogger(StatusPanel.class);
    private Map<String, StatusBean> initialStatusBeanMap;
    private ListViewPanel<?> listViewPanel;

    public <T extends AnyTO> StatusPanel(String id, T any, IModel<List<StatusBean>> model, PageReference pageRef) {
        super(id);
        this.init(any, model, StatusUtils.getReconStatuses(any.getType(), any.getKey(), any.getResources()).stream().map(status -> Triple.of((Object)((ReconStatus)status.getRight()).getOnSyncope(), (Object)new ConnObjectWrapper(any, (String)status.getLeft(), ((ReconStatus)status.getRight()).getOnResource()), null)).collect(Collectors.toList()), pageRef, false);
    }

    public <T extends AnyTO> StatusPanel(String id, T any, IModel<List<StatusBean>> model, List<Triple<ConnObjectTO, ConnObjectWrapper, String>> connObjects, PageReference pageRef) {
        super(id);
        this.init(any, model, connObjects, pageRef, true);
    }

    private void init(AnyTO any, IModel<List<StatusBean>> model, final List<Triple<ConnObjectTO, ConnObjectWrapper, String>> connObjects, PageReference pageRef, boolean enableConnObjectLink) {
        ArrayList<StatusBean> statusBeans = new ArrayList<StatusBean>(connObjects.size() + 1);
        this.initialStatusBeanMap = new LinkedHashMap<String, StatusBean>(connObjects.size() + 1);
        StatusBean syncope = new StatusBean(any, "syncope");
        if (any instanceof UserTO) {
            syncope.setConnObjectLink(((UserTO)any).getUsername());
            Status syncopeStatus = Status.UNDEFINED;
            if (((UserTO)any).getStatus() != null) {
                try {
                    syncopeStatus = Status.valueOf(((UserTO)any).getStatus().toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Unexpected status found: {}", (Object)((UserTO)any).getStatus(), (Object)e);
                }
            }
            syncope.setStatus(syncopeStatus);
        } else if (any instanceof GroupTO) {
            syncope.setConnObjectLink(((GroupTO)any).getName());
            syncope.setStatus(Status.ACTIVE);
        }
        statusBeans.add(syncope);
        this.initialStatusBeanMap.put(syncope.getResource(), syncope);
        final HashMap failureReasons = new HashMap();
        connObjects.forEach(triple -> {
            ConnObjectWrapper connObjectWrapper = (ConnObjectWrapper)triple.getMiddle();
            StatusBean statusBean = StatusUtils.getStatusBean(connObjectWrapper.getAny(), connObjectWrapper.getResource(), connObjectWrapper.getConnObjectTO(), any instanceof GroupTO);
            this.initialStatusBeanMap.put(connObjectWrapper.getResource(), statusBean);
            statusBeans.add(statusBean);
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)triple.getRight()))) {
                failureReasons.put(connObjectWrapper.getResource(), triple.getRight());
            }
        });
        final MultilevelPanel mlp = new MultilevelPanel("resources");
        this.add(new Component[]{mlp});
        ListViewPanel.Builder<StatusBean> builder = new ListViewPanel.Builder<StatusBean>(StatusBean.class, pageRef){
            private static final long serialVersionUID = -6809736686861678498L;

            @Override
            protected Component getValueComponent(String key, StatusBean bean) {
                if ("status".equalsIgnoreCase(key)) {
                    return StatusUtils.getStatusImagePanel("field", bean.getStatus());
                }
                return super.getValueComponent(key, bean);
            }
        };
        builder.setModel(model);
        builder.setItems(statusBeans);
        builder.includes("resource", "connObjectLink", "status");
        builder.withChecks(ListViewPanel.CheckAvailability.NONE);
        builder.setReuseItem(false);
        ActionLink<StatusBean> connObjectLink = new ActionLink<StatusBean>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            protected boolean statusCondition(StatusBean bean) {
                Pair<ConnObjectTO, ConnObjectTO> pair = StatusPanel.this.getConnObjectTOs(bean.getKey(), bean.getResource(), connObjects);
                return pair != null && pair.getRight() != null;
            }

            @Override
            public void onClick(AjaxRequestTarget target, StatusBean bean) {
                mlp.next(bean.getResource(), new RemoteAnyPanel(bean, connObjects), target);
            }
        };
        if (!enableConnObjectLink) {
            connObjectLink.disable();
        }
        builder.addAction(connObjectLink, ActionLink.ActionType.VIEW, "RESOURCE_GET_CONNOBJECT");
        builder.addAction(new ActionLink<StatusBean>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            protected boolean statusCondition(StatusBean bean) {
                return failureReasons.containsKey(bean.getResource());
            }

            @Override
            public void onClick(AjaxRequestTarget target, StatusBean bean) {
                mlp.next(bean.getResource(), new PropagationErrorPanel((String)failureReasons.get(bean.getResource())), target);
            }
        }, ActionLink.ActionType.PROPAGATION_TASKS, "");
        this.listViewPanel = (ListViewPanel)((Object)ListViewPanel.class.cast((Object)builder.build("first")));
        mlp.setFirstLevel(this.listViewPanel);
    }

    public void setCheckAvailability(ListViewPanel.CheckAvailability check) {
        this.listViewPanel.setCheckAvailability(check);
    }

    public Map<String, StatusBean> getInitialStatusBeanMap() {
        return this.initialStatusBeanMap;
    }

    protected Pair<ConnObjectTO, ConnObjectTO> getConnObjectTOs(String anyKey, String resource, List<Triple<ConnObjectTO, ConnObjectWrapper, String>> objects) {
        for (Triple<ConnObjectTO, ConnObjectWrapper, String> object : objects) {
            if (!anyKey.equals(((ConnObjectWrapper)object.getMiddle()).getAny().getKey()) || !resource.equalsIgnoreCase(((ConnObjectWrapper)object.getMiddle()).getResource())) continue;
            return Pair.of((Object)object.getLeft(), (Object)((ConnObjectWrapper)object.getMiddle()).getConnObjectTO());
        }
        return null;
    }

    class RemoteAnyPanel
    extends RemoteObjectPanel {
        private static final long serialVersionUID = 4303365227411467563L;
        private final StatusBean bean;
        private final List<Triple<ConnObjectTO, ConnObjectWrapper, String>> connObjects;

        RemoteAnyPanel(StatusBean bean, List<Triple<ConnObjectTO, ConnObjectWrapper, String>> connObjects) {
            this.bean = bean;
            this.connObjects = connObjects;
            this.add(new Component[]{new ConnObjectPanel("remoteObject", Pair.of((Object)new ResourceModel("before"), (Object)new ResourceModel("after")), this.getConnObjectTOs(), false)});
        }

        @Override
        protected final Pair<ConnObjectTO, ConnObjectTO> getConnObjectTOs() {
            return StatusPanel.this.getConnObjectTOs(this.bean.getKey(), this.bean.getResource(), this.connObjects);
        }
    }
}

