/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.topology.TopologyNode;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.resources.AbstractResourceWizardBuilder;
import org.apache.syncope.client.console.wizards.resources.ConnCapabilitiesPanel;
import org.apache.syncope.client.console.wizards.resources.ConnectorConfPanel;
import org.apache.syncope.client.console.wizards.resources.ConnectorDetailsPanel;
import org.apache.syncope.common.lib.to.ConnBundleTO;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.types.ConnectorCapability;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.PropertyModel;

public class ConnectorWizardBuilder
extends AbstractResourceWizardBuilder<ConnInstanceTO> {
    private static final long serialVersionUID = -2025535531121434050L;
    private final ConnectorRestClient connectorRestClient = new ConnectorRestClient();
    private final List<ConnBundleTO> bundles = this.connectorRestClient.getAllBundles().stream().filter(object -> object.getLocation().equals(defaultItem.getLocation())).collect(Collectors.toList());

    public ConnectorWizardBuilder(ConnInstanceTO defaultItem, PageReference pageRef) {
        super(defaultItem, pageRef);
    }

    @Override
    protected WizardModel buildModelSteps(Serializable modelObject, WizardModel wizardModel) {
        ConnInstanceTO connInstanceTO = (ConnInstanceTO)ConnInstanceTO.class.cast(modelObject);
        wizardModel.add((IWizardStep)new ConnectorDetailsPanel(connInstanceTO, this.bundles));
        wizardModel.add((IWizardStep)new ConnectorConfPanel(connInstanceTO, this.bundles){
            private static final long serialVersionUID = -5886691077681158494L;

            @Override
            protected Pair<Boolean, String> check(AjaxRequestTarget target) {
                ConnInstanceTO connInstanceTO = (ConnInstanceTO)ConnInstanceTO.class.cast(this.modelObject);
                ConnBundleTO bundleTO = ConnectorWizardBuilder.getBundle(connInstanceTO, ConnectorWizardBuilder.this.bundles);
                connInstanceTO.setConnectorName(bundleTO.getConnectorName());
                connInstanceTO.setBundleName(bundleTO.getBundleName());
                connInstanceTO.setVersion(bundleTO.getVersion());
                return ConnectorWizardBuilder.this.connectorRestClient.check(connInstanceTO);
            }

            protected void onComponentTag(ComponentTag tag) {
                tag.append("class", (CharSequence)"scrollable-tab-content", " ");
            }
        });
        wizardModel.add((IWizardStep)new ConnCapabilitiesPanel((PropertyModel<List<ConnectorCapability>>)new PropertyModel((Object)connInstanceTO, "capabilities")));
        return wizardModel;
    }

    protected ConnInstanceTO onApplyInternal(Serializable modelObject) {
        ConnInstanceTO res;
        ConnInstanceTO connInstanceTO = (ConnInstanceTO)ConnInstanceTO.class.cast(modelObject);
        ConnBundleTO bundleTO = ConnectorWizardBuilder.getBundle(connInstanceTO, this.bundles);
        connInstanceTO.setConnectorName(bundleTO.getConnectorName());
        connInstanceTO.setBundleName(bundleTO.getBundleName());
        connInstanceTO.setVersion(bundleTO.getVersion());
        if (connInstanceTO.getPoolConf() != null && connInstanceTO.getPoolConf().getMaxIdle() == null && connInstanceTO.getPoolConf().getMaxObjects() == null && connInstanceTO.getPoolConf().getMaxWait() == null && connInstanceTO.getPoolConf().getMinEvictableIdleTimeMillis() == null && connInstanceTO.getPoolConf().getMinIdle() == null) {
            connInstanceTO.setPoolConf(null);
        }
        if (this.mode == AjaxWizard.Mode.CREATE) {
            res = this.connectorRestClient.create(connInstanceTO);
        } else {
            this.connectorRestClient.update(connInstanceTO);
            res = connInstanceTO;
        }
        return res;
    }

    @Override
    protected Serializable getCreateCustomPayloadEvent(Serializable afterObject, AjaxRequestTarget target) {
        ConnInstanceTO actual = (ConnInstanceTO)ConnInstanceTO.class.cast(afterObject);
        return new AbstractResourceWizardBuilder.CreateEvent(actual.getKey(), actual.getDisplayName(), TopologyNode.Kind.CONNECTOR, (Serializable)((Object)URI.create(actual.getLocation()).toASCIIString()), target);
    }

    protected static ConnBundleTO getBundle(ConnInstanceTO connInstanceTO, List<ConnBundleTO> bundles) {
        List<Object> bundlesList;
        if (bundles.isEmpty()) {
            ConnectorRestClient connectorRestClient = new ConnectorRestClient();
            bundlesList = connectorRestClient.getAllBundles().stream().filter(object -> object.getLocation().equals(connInstanceTO.getLocation())).collect(Collectors.toList());
        } else {
            bundlesList = bundles;
        }
        return bundlesList.stream().filter(bundle -> bundle.getBundleName().equals(connInstanceTO.getBundleName()) && bundle.getVersion().equals(connInstanceTO.getVersion())).findFirst().orElse(null);
    }
}

