/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.lib;

import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;

public class RestClientFactoryBean
extends JAXRSClientFactoryBean {
    public static final String HEADER_SPLIT_PROPERTY = "org.apache.cxf.http.header.split";

    public <T> T createServiceInstance(Class<T> serviceClass, MediaType mediaType) {
        return this.createServiceInstance(serviceClass, mediaType, null, null, false);
    }

    public <T> T createServiceInstance(Class<T> serviceClass, MediaType mediaType, String username, String password, boolean useCompression) {
        if (StringUtils.isNotBlank((CharSequence)username)) {
            this.setUsername(username);
        }
        if (StringUtils.isNotBlank((CharSequence)password)) {
            this.setPassword(password);
        }
        this.setServiceClass(serviceClass);
        Object serviceInstance = this.create(serviceClass, new Object[0]);
        Client client = WebClient.client((Object)serviceInstance);
        client.type(mediaType).accept(new MediaType[]{mediaType});
        ClientConfiguration config = WebClient.getConfig((Object)client);
        config.getRequestContext().put(HEADER_SPLIT_PROPERTY, true);
        config.getRequestContext().put("use.httpurlconnection.method.reflection", true);
        if (useCompression) {
            config.getInInterceptors().add(new GZIPInInterceptor());
            config.getOutInterceptors().add(new GZIPOutInterceptor());
        }
        return (T)serviceInstance;
    }
}

