/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.InputStream;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Syncope")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="")
public interface SyncopeService
extends JAXRSService {
    @Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference to process the batch request asynchronously", allowEmptyValue=true, schema=@Schema(defaultValue="", allowableValues={"respond-async"}))
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Batch request processed, results returned as Response entity, in case no 'Prefer: respond-async' was specified"), @ApiResponse(responseCode="202", description="Batch accepted for asynchronous processing, in case 'Prefer: respond-async' was specified", headers={@Header(name="Location", schema=@Schema(type="string"), description="URL to poll in order to get the results of the requested batch processing"), @Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @POST
    @Path(value="/batch")
    @Consumes(value={"multipart/mixed"})
    @Produces(value={"multipart/mixed"})
    public Response batch(InputStream var1);

    @GET
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Batch results available, returned as Response entity"), @ApiResponse(responseCode="202", description="Batch results not yet available, retry later", headers={@Header(name="Location", schema=@Schema(type="string"), description="URL to poll in order to get the results of the requested batch processing"), @Header(name="Retry-After", schema=@Schema(type="integer"), description="seconds after which attempt again to get batch results")}), @ApiResponse(responseCode="404", description="No batch process was found for the provided boundary")})
    @Path(value="/batch")
    @Produces(value={"multipart/mixed"})
    public Response batch();

    @POST
    @Path(value="/assignableGroups/{realm:.*}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public PagedResult<GroupTO> searchAssignableGroups(@NotNull @PathParam(value="realm") String var1, @QueryParam(value="term") String var2, @Min(value=1L) @QueryParam(value="page") @DefaultValue(value="1") @Min(value=1L) int var3, @Min(value=1L) @QueryParam(value="size") @DefaultValue(value="25") @Min(value=1L) int var4);

    @GET
    @Path(value="/userTypeExtension/{groupName}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public TypeExtensionTO readUserTypeExtension(@NotNull @PathParam(value="groupName") String var1);

    @GET
    @Path(value="internalStorage/stream")
    public Response exportInternalStorageContent();
}

