/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.to.EventCategoryTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.LoggerType;

public class AuditLoggerName
extends AbstractBaseBean {
    private static final long serialVersionUID = -647989486671786839L;
    private final AuditElements.EventCategoryType type;
    private final String category;
    private final String subcategory;
    private final String event;
    private final AuditElements.Result result;

    @JsonCreator
    public AuditLoggerName(@JsonProperty(value="type") AuditElements.EventCategoryType type, @JsonProperty(value="category") String category, @JsonProperty(value="subcategory") String subcategory, @JsonProperty(value="event") String event, @JsonProperty(value="result") AuditElements.Result result) {
        this.type = type == null ? AuditElements.EventCategoryType.CUSTOM : type;
        this.category = category;
        this.subcategory = subcategory;
        this.event = event;
        this.result = result == null ? AuditElements.Result.SUCCESS : result;
    }

    public AuditElements.EventCategoryType getType() {
        return this.type;
    }

    public String getEvent() {
        return this.event;
    }

    public String getCategory() {
        return this.category;
    }

    public AuditElements.Result getResult() {
        return this.result;
    }

    public String getSubcategory() {
        return this.subcategory;
    }

    public String toLoggerName() {
        return LoggerType.AUDIT.getPrefix() + '.' + AuditLoggerName.buildEvent(this.type, this.category, this.subcategory, this.event, this.result);
    }

    public static AuditLoggerName fromLoggerName(String loggerName) throws ParseException {
        if (StringUtils.isBlank((CharSequence)loggerName)) {
            throw new IllegalArgumentException("Null value not permitted");
        }
        if (!loggerName.startsWith(LoggerType.AUDIT.getPrefix())) {
            throw new ParseException("Audit logger name must start with " + LoggerType.AUDIT.getPrefix(), 0);
        }
        Pair<EventCategoryTO, AuditElements.Result> eventCategory = AuditLoggerName.parseEventCategory(loggerName.replaceAll(LoggerType.AUDIT.getPrefix() + ".", ""));
        return new AuditLoggerName(((EventCategoryTO)eventCategory.getKey()).getType(), ((EventCategoryTO)eventCategory.getKey()).getCategory(), ((EventCategoryTO)eventCategory.getKey()).getSubcategory(), ((EventCategoryTO)eventCategory.getKey()).getEvents().isEmpty() ? "" : ((EventCategoryTO)eventCategory.getKey()).getEvents().iterator().next(), (AuditElements.Result)((Object)eventCategory.getValue()));
    }

    public static Pair<EventCategoryTO, AuditElements.Result> parseEventCategory(String event) {
        EventCategoryTO eventCategoryTO = new EventCategoryTO();
        AuditElements.Result condition = null;
        if (StringUtils.isNotEmpty((CharSequence)event)) {
            String[] elements = event.substring(1, event.length() - 1).split("\\]:\\[");
            if (elements.length == 1) {
                eventCategoryTO.setType(AuditElements.EventCategoryType.CUSTOM);
                condition = AuditElements.Result.SUCCESS;
                eventCategoryTO.getEvents().add(event);
            } else {
                AuditElements.EventCategoryType type;
                if (AuditElements.EventCategoryType.PROPAGATION.toString().equals(elements[0])) {
                    type = AuditElements.EventCategoryType.PROPAGATION;
                } else if (AuditElements.EventCategoryType.PULL.toString().equals(elements[0])) {
                    type = AuditElements.EventCategoryType.PULL;
                } else if (AuditElements.EventCategoryType.PUSH.toString().equals(elements[0])) {
                    type = AuditElements.EventCategoryType.PUSH;
                } else {
                    try {
                        type = AuditElements.EventCategoryType.valueOf(elements[0]);
                    }
                    catch (Exception e) {
                        type = AuditElements.EventCategoryType.CUSTOM;
                    }
                }
                eventCategoryTO.setType(type);
                eventCategoryTO.setCategory(StringUtils.isNotEmpty((CharSequence)elements[1]) ? elements[1] : null);
                eventCategoryTO.setSubcategory(StringUtils.isNotEmpty((CharSequence)elements[2]) ? elements[2] : null);
                if (elements.length > 3 && StringUtils.isNotEmpty((CharSequence)elements[3])) {
                    eventCategoryTO.getEvents().add(elements[3]);
                }
                if (elements.length > 4) {
                    condition = AuditElements.Result.valueOf(elements[4].toUpperCase());
                }
            }
        }
        return new ImmutablePair((Object)eventCategoryTO, condition);
    }

    public static String buildEvent(AuditElements.EventCategoryType type, String category, String subcategory, String event, AuditElements.Result resultValueCondition) {
        StringBuilder eventBuilder = new StringBuilder();
        eventBuilder.append('[');
        if (type != null) {
            if (StringUtils.isNotBlank((CharSequence)type.toString())) {
                eventBuilder.append(type.toString());
            } else {
                eventBuilder.append(type.name());
            }
        }
        eventBuilder.append("]:[");
        if (StringUtils.isNotBlank((CharSequence)category)) {
            eventBuilder.append(category);
        }
        eventBuilder.append("]:[");
        if (StringUtils.isNotBlank((CharSequence)subcategory)) {
            eventBuilder.append(subcategory);
        }
        eventBuilder.append("]:[");
        if (StringUtils.isNotBlank((CharSequence)event)) {
            eventBuilder.append(event);
        }
        eventBuilder.append(']');
        if (resultValueCondition != null) {
            eventBuilder.append(":[").append((Object)resultValueCondition).append(']');
        }
        return eventBuilder.toString();
    }
}

