/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;

@XmlRootElement(name="anyObject")
@XmlType
@ApiModel(parent=AnyTO.class)
public class AnyObjectTO
extends AnyTO
implements GroupableRelatableTO {
    private static final long serialVersionUID = 8841697496476959639L;
    private String name;
    private final List<RelationshipTO> relationships = new ArrayList<RelationshipTO>();
    private final List<MembershipTO> memberships = new ArrayList<MembershipTO>();
    private final List<MembershipTO> dynMemberships = new ArrayList<MembershipTO>();

    @Override
    @XmlTransient
    @JsonProperty(value="@class")
    @ApiModelProperty(name="@class", required=true, example="org.apache.syncope.common.lib.to.AnyObjectTO")
    public String getDiscriminator() {
        return this.getClass().getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonIgnore
    public RelationshipTO getRelationship(final String type, final String otherKey) {
        return (RelationshipTO)IterableUtils.find(this.relationships, (Predicate)new Predicate<RelationshipTO>(){

            public boolean evaluate(RelationshipTO object) {
                return type.equals(object.getType()) && otherKey.equals(object.getOtherEndKey());
            }
        });
    }

    @Override
    @XmlElementWrapper(name="relationships")
    @XmlElement(name="relationship")
    @JsonProperty(value="relationships")
    public List<RelationshipTO> getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonIgnore
    public MembershipTO getMembership(final String groupKey) {
        return (MembershipTO)IterableUtils.find(this.memberships, (Predicate)new Predicate<MembershipTO>(){

            public boolean evaluate(MembershipTO object) {
                return groupKey.equals(object.getGroupKey());
            }
        });
    }

    @Override
    @XmlElementWrapper(name="memberships")
    @XmlElement(name="membership")
    @JsonProperty(value="memberships")
    public List<MembershipTO> getMemberships() {
        return this.memberships;
    }

    @Override
    @ApiModelProperty(readOnly=true)
    @XmlElementWrapper(name="dynMemberships")
    @XmlElement(name="dynMembership")
    @JsonProperty(value="dynMemberships")
    public List<MembershipTO> getDynMemberships() {
        return this.dynMemberships;
    }
}

