/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AbstractReplacePatchItem;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.AttrPatch;
import org.apache.syncope.common.lib.patch.BooleanReplacePatchItem;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.patch.MembershipPatch;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.RelationshipPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.patch.StringReplacePatchItem;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnyOperations {
    private static final Logger LOG = LoggerFactory.getLogger(AnyOperations.class);

    private AnyOperations() {
    }

    private static <T, K extends AbstractReplacePatchItem<T>> K replacePatchItem(T updated, T original, K proto) {
        if (original == null && updated == null || original != null && original.equals(updated)) {
            return null;
        }
        proto.setValue(updated);
        return proto;
    }

    private static void diff(MembershipTO updated, MembershipTO original, final MembershipPatch result, boolean incremental) {
        if (updated.getGroupKey() == null && original.getGroupKey() != null || updated.getGroupKey() != null && !updated.getGroupKey().equals(original.getGroupKey())) {
            throw new IllegalArgumentException("Memberships must be the same");
        }
        result.setGroup(updated.getGroupKey());
        HashMap<String, AttrTO> updatedAttrs = new HashMap<String, AttrTO>(updated.getPlainAttrMap());
        HashMap<String, AttrTO> originalAttrs = new HashMap<String, AttrTO>(original.getPlainAttrMap());
        result.getPlainAttrs().clear();
        if (!incremental) {
            IterableUtils.forEach((Iterable)CollectionUtils.subtract(originalAttrs.keySet(), updatedAttrs.keySet()), (Closure)new Closure<String>(){

                public void execute(String schema) {
                    result.getPlainAttrs().add((AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder().operation(PatchOperation.DELETE)).attrTO(new AttrTO.Builder().schema(schema).build()).build());
                }
            });
        }
        for (AttrTO attrTO : updatedAttrs.values()) {
            if (attrTO.getValues().isEmpty()) {
                if (incremental) continue;
                result.getPlainAttrs().add((AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder().operation(PatchOperation.DELETE)).attrTO(new AttrTO.Builder().schema(attrTO.getSchema()).build()).build());
                continue;
            }
            AttrPatch patch = (AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder().operation(PatchOperation.ADD_REPLACE)).attrTO(attrTO).build();
            if (patch.isEmpty()) continue;
            result.getPlainAttrs().add(patch);
        }
        result.getVirAttrs().clear();
        result.getVirAttrs().addAll(updated.getVirAttrs());
    }

    private static void diff(AnyTO updated, AnyTO original, final AnyPatch result, boolean incremental) {
        if (updated.getKey() == null && original.getKey() != null || updated.getKey() != null && !updated.getKey().equals(original.getKey())) {
            throw new IllegalArgumentException("AnyTO's key must be the same");
        }
        result.setKey(updated.getKey());
        result.setRealm(AnyOperations.replacePatchItem(updated.getRealm(), original.getRealm(), new StringReplacePatchItem()));
        result.getAuxClasses().clear();
        if (!incremental) {
            for (String auxClass : CollectionUtils.subtract(original.getAuxClasses(), updated.getAuxClasses())) {
                result.getAuxClasses().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(auxClass)).build());
            }
        }
        for (String auxClass : CollectionUtils.subtract(updated.getAuxClasses(), original.getAuxClasses())) {
            result.getAuxClasses().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(auxClass)).build());
        }
        HashMap<String, AttrTO> updatedAttrs = new HashMap<String, AttrTO>(updated.getPlainAttrMap());
        HashMap<String, AttrTO> originalAttrs = new HashMap<String, AttrTO>(original.getPlainAttrMap());
        result.getPlainAttrs().clear();
        if (!incremental) {
            IterableUtils.forEach((Iterable)CollectionUtils.subtract(originalAttrs.keySet(), updatedAttrs.keySet()), (Closure)new Closure<String>(){

                public void execute(String schema) {
                    result.getPlainAttrs().add((AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder().operation(PatchOperation.DELETE)).attrTO(new AttrTO.Builder().schema(schema).build()).build());
                }
            });
        }
        for (AttrTO attrTO : updatedAttrs.values()) {
            AttrPatch patch;
            if (attrTO.getValues().isEmpty()) {
                if (incremental) continue;
                result.getPlainAttrs().add((AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder().operation(PatchOperation.DELETE)).attrTO(new AttrTO.Builder().schema(attrTO.getSchema()).build()).build());
                continue;
            }
            if (originalAttrs.containsKey(attrTO.getSchema()) && ((AttrTO)originalAttrs.get(attrTO.getSchema())).getValues().equals(attrTO.getValues()) || (patch = (AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder().operation(PatchOperation.ADD_REPLACE)).attrTO(attrTO).build()).isEmpty()) continue;
            result.getPlainAttrs().add(patch);
        }
        result.getVirAttrs().clear();
        result.getVirAttrs().addAll(updated.getVirAttrs());
        result.getResources().clear();
        if (!incremental) {
            for (String resource : CollectionUtils.subtract(original.getResources(), updated.getResources())) {
                result.getResources().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(resource)).build());
            }
        }
        for (String resource : CollectionUtils.subtract(updated.getResources(), original.getResources())) {
            result.getResources().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(resource)).build());
        }
    }

    public static AnyObjectPatch diff(AnyObjectTO updated, AnyObjectTO original, boolean incremental) {
        AnyObjectPatch result = new AnyObjectPatch();
        AnyOperations.diff(updated, original, result, incremental);
        result.setName(AnyOperations.replacePatchItem(updated.getName(), original.getName(), new StringReplacePatchItem()));
        Map<Pair<String, String>, RelationshipTO> updatedRels = updated.getRelationshipMap();
        Map<Pair<String, String>, RelationshipTO> originalRels = original.getRelationshipMap();
        for (Map.Entry<Pair<String, String>, RelationshipTO> entry : updatedRels.entrySet()) {
            if (originalRels.containsKey(entry.getKey())) continue;
            result.getRelationships().add((RelationshipPatch)((RelationshipPatch.Builder)new RelationshipPatch.Builder().operation(PatchOperation.ADD_REPLACE)).relationshipTO(entry.getValue()).build());
        }
        if (!incremental) {
            for (Pair key : CollectionUtils.subtract(originalRels.keySet(), updatedRels.keySet())) {
                result.getRelationships().add((RelationshipPatch)((RelationshipPatch.Builder)new RelationshipPatch.Builder().operation(PatchOperation.DELETE)).relationshipTO(originalRels.get(key)).build());
            }
        }
        Map<String, MembershipTO> updatedMembs = updated.getMembershipMap();
        Map<String, MembershipTO> originalMembs = original.getMembershipMap();
        for (Map.Entry<String, MembershipTO> entry : updatedMembs.entrySet()) {
            if (originalMembs.containsKey(entry.getKey())) continue;
            result.getMemberships().add((MembershipPatch)((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.ADD_REPLACE)).group(entry.getValue().getGroupKey()).build());
        }
        if (!incremental) {
            for (String key : CollectionUtils.subtract(originalMembs.keySet(), updatedMembs.keySet())) {
                result.getMemberships().add((MembershipPatch)((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.DELETE)).group(originalMembs.get(key).getGroupKey()).build());
            }
        }
        return result;
    }

    public static UserPatch diff(UserTO updated, UserTO original, boolean incremental) {
        UserPatch result = new UserPatch();
        AnyOperations.diff(updated, original, result, incremental);
        if (!(updated.getPassword() == null || original.getPassword() != null && original.getPassword().equals(updated.getPassword()))) {
            result.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value(updated.getPassword())).build());
        }
        result.setUsername(AnyOperations.replacePatchItem(updated.getUsername(), original.getUsername(), new StringReplacePatchItem()));
        if (updated.getSecurityQuestion() == null) {
            result.setSecurityQuestion(null);
            result.setSecurityAnswer(null);
        } else if (!updated.getSecurityQuestion().equals(original.getSecurityQuestion()) || StringUtils.isNotBlank((CharSequence)updated.getSecurityAnswer())) {
            result.setSecurityQuestion((StringReplacePatchItem)((StringReplacePatchItem.Builder)new StringReplacePatchItem.Builder().value(updated.getSecurityQuestion())).build());
            result.setSecurityAnswer((StringReplacePatchItem)((StringReplacePatchItem.Builder)new StringReplacePatchItem.Builder().value(updated.getSecurityAnswer())).build());
        }
        result.setMustChangePassword(AnyOperations.replacePatchItem(updated.isMustChangePassword(), original.isMustChangePassword(), new BooleanReplacePatchItem()));
        if (!incremental) {
            for (String toRemove : CollectionUtils.subtract(original.getRoles(), updated.getRoles())) {
                result.getRoles().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(toRemove)).build());
            }
        }
        for (String toAdd : CollectionUtils.subtract(updated.getRoles(), original.getRoles())) {
            result.getRoles().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(toAdd)).build());
        }
        Map<Pair<String, String>, RelationshipTO> updatedRels = updated.getRelationshipMap();
        Map<Pair<String, String>, RelationshipTO> originalRels = original.getRelationshipMap();
        for (Map.Entry<Pair<String, String>, RelationshipTO> entry : updatedRels.entrySet()) {
            if (originalRels.containsKey(entry.getKey())) continue;
            result.getRelationships().add((RelationshipPatch)((RelationshipPatch.Builder)new RelationshipPatch.Builder().operation(PatchOperation.ADD_REPLACE)).relationshipTO(entry.getValue()).build());
        }
        if (!incremental) {
            for (Pair key : CollectionUtils.subtract(originalRels.keySet(), updatedRels.keySet())) {
                result.getRelationships().add((RelationshipPatch)((RelationshipPatch.Builder)new RelationshipPatch.Builder().operation(PatchOperation.DELETE)).relationshipTO(originalRels.get(key)).build());
            }
        }
        Map<String, MembershipTO> updatedMembs = updated.getMembershipMap();
        Map<String, MembershipTO> originalMembs = original.getMembershipMap();
        for (Map.Entry<String, MembershipTO> entry : updatedMembs.entrySet()) {
            MembershipTO omemb;
            MembershipPatch membershipPatch = (MembershipPatch)((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.ADD_REPLACE)).group(entry.getValue().getGroupKey()).build();
            if (originalMembs.containsKey(entry.getKey())) {
                omemb = originalMembs.get(entry.getKey());
            } else {
                omemb = new MembershipTO();
                omemb.setGroupKey(entry.getKey());
            }
            AnyOperations.diff(entry.getValue(), omemb, membershipPatch, incremental);
            result.getMemberships().add(membershipPatch);
        }
        if (!incremental) {
            for (String key : CollectionUtils.subtract(originalMembs.keySet(), updatedMembs.keySet())) {
                result.getMemberships().add((MembershipPatch)((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.DELETE)).group(originalMembs.get(key).getGroupKey()).build());
            }
        }
        return result;
    }

    public static GroupPatch diff(GroupTO updated, GroupTO original, boolean incremental) {
        GroupPatch result = new GroupPatch();
        AnyOperations.diff(updated, original, result, incremental);
        result.setName(AnyOperations.replacePatchItem(updated.getName(), original.getName(), new StringReplacePatchItem()));
        result.setUserOwner(AnyOperations.replacePatchItem(updated.getUserOwner(), original.getUserOwner(), new StringReplacePatchItem()));
        result.setGroupOwner(AnyOperations.replacePatchItem(updated.getGroupOwner(), original.getGroupOwner(), new StringReplacePatchItem()));
        result.setUDynMembershipCond(updated.getUDynMembershipCond());
        result.getADynMembershipConds().putAll(updated.getADynMembershipConds());
        result.getTypeExtensions().addAll(updated.getTypeExtensions());
        return result;
    }

    public static <TO extends AnyTO, P extends AnyPatch> P diff(TO updated, TO original, boolean incremental) {
        if (updated instanceof UserTO && original instanceof UserTO) {
            return (P)AnyOperations.diff((UserTO)updated, (UserTO)original, incremental);
        }
        if (updated instanceof GroupTO && original instanceof GroupTO) {
            return (P)AnyOperations.diff((GroupTO)updated, (GroupTO)original, incremental);
        }
        if (updated instanceof AnyObjectTO && original instanceof AnyObjectTO) {
            return (P)AnyOperations.diff((AnyObjectTO)updated, (AnyObjectTO)original, incremental);
        }
        throw new IllegalArgumentException("Unsupported: " + updated.getClass().getName());
    }

    private static Collection<AttrTO> patch(Map<String, AttrTO> attrs, Set<AttrPatch> attrPatches) {
        HashMap<String, AttrTO> rwattrs = new HashMap<String, AttrTO>(attrs);
        block3: for (AttrPatch patch : attrPatches) {
            if (patch.getAttrTO() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)AttrPatch.class.getName(), (Object)patch);
                continue;
            }
            rwattrs.remove(patch.getAttrTO().getSchema());
            if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                rwattrs.put(patch.getAttrTO().getSchema(), patch.getAttrTO());
            }
            switch (patch.getOperation()) {
                case ADD_REPLACE: {
                    if (!rwattrs.containsKey(patch.getAttrTO().getSchema())) continue block3;
                    rwattrs.remove(patch.getAttrTO().getSchema());
                    continue block3;
                }
            }
            rwattrs.remove(patch.getAttrTO().getSchema());
        }
        return rwattrs.values();
    }

    private static <T extends AnyTO, K extends AnyPatch> void patch(T to, K patch, T result) {
        if (to.getKey() == null || !to.getKey().equals(patch.getKey())) {
            throw new IllegalArgumentException(to.getClass().getSimpleName() + " and " + patch.getClass().getSimpleName() + " keys must be the same");
        }
        if (patch.getRealm() != null) {
            result.setRealm((String)patch.getRealm().getValue());
        }
        block6: for (StringPatchItem auxClassPatch : patch.getAuxClasses()) {
            switch (auxClassPatch.getOperation()) {
                case ADD_REPLACE: {
                    to.getAuxClasses().add((String)auxClassPatch.getValue());
                    continue block6;
                }
            }
            to.getAuxClasses().remove(auxClassPatch.getValue());
        }
        result.getPlainAttrs().clear();
        result.getPlainAttrs().addAll(AnyOperations.patch(to.getPlainAttrMap(), patch.getPlainAttrs()));
        result.getVirAttrs().clear();
        result.getVirAttrs().addAll(patch.getVirAttrs());
        block7: for (StringPatchItem resourcePatch : patch.getResources()) {
            switch (resourcePatch.getOperation()) {
                case ADD_REPLACE: {
                    result.getResources().add((String)resourcePatch.getValue());
                    continue block7;
                }
            }
            result.getResources().remove(resourcePatch.getValue());
        }
    }

    public static GroupTO patch(GroupTO groupTO, GroupPatch groupPatch) {
        GroupTO result = (GroupTO)SerializationUtils.clone((Serializable)groupTO);
        AnyOperations.patch(groupTO, groupPatch, result);
        if (groupPatch.getName() != null) {
            result.setName((String)groupPatch.getName().getValue());
        }
        if (groupPatch.getUserOwner() != null) {
            result.setGroupOwner((String)groupPatch.getUserOwner().getValue());
        }
        if (groupPatch.getGroupOwner() != null) {
            result.setGroupOwner((String)groupPatch.getGroupOwner().getValue());
        }
        result.setUDynMembershipCond(groupPatch.getUDynMembershipCond());
        result.getADynMembershipConds().clear();
        result.getADynMembershipConds().putAll(groupPatch.getADynMembershipConds());
        return result;
    }

    public static AnyObjectTO patch(AnyObjectTO anyObjectTO, AnyObjectPatch anyObjectPatch) {
        AnyObjectTO result = (AnyObjectTO)SerializationUtils.clone((Serializable)anyObjectTO);
        AnyOperations.patch(anyObjectTO, anyObjectPatch, result);
        if (anyObjectPatch.getName() != null) {
            result.setName((String)anyObjectPatch.getName().getValue());
        }
        for (RelationshipPatch relPatch : anyObjectPatch.getRelationships()) {
            if (relPatch.getRelationshipTO() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)RelationshipPatch.class.getName(), (Object)relPatch);
                continue;
            }
            result.getRelationships().remove(relPatch.getRelationshipTO());
            if (relPatch.getOperation() != PatchOperation.ADD_REPLACE) continue;
            result.getRelationships().add(relPatch.getRelationshipTO());
        }
        for (final MembershipPatch membPatch : anyObjectPatch.getMemberships()) {
            if (membPatch.getGroup() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)MembershipPatch.class.getName(), (Object)membPatch);
                continue;
            }
            MembershipTO memb = (MembershipTO)IterableUtils.find(result.getMemberships(), (Predicate)new Predicate<MembershipTO>(){

                public boolean evaluate(MembershipTO object) {
                    return membPatch.getGroup().equals(object.getGroupKey());
                }
            });
            if (memb != null) {
                result.getMemberships().remove(memb);
            }
            if (membPatch.getOperation() != PatchOperation.ADD_REPLACE) continue;
            MembershipTO newMembershipTO = new MembershipTO();
            newMembershipTO.setGroupKey(membPatch.getGroup());
            if (memb == null) {
                for (AttrPatch attrPatch : membPatch.getPlainAttrs()) {
                    newMembershipTO.getPlainAttrs().add(attrPatch.getAttrTO());
                }
            } else {
                newMembershipTO.getPlainAttrs().addAll(AnyOperations.patch(memb.getPlainAttrMap(), membPatch.getPlainAttrs()));
            }
            newMembershipTO.getVirAttrs().addAll(membPatch.getVirAttrs());
            result.getMemberships().add(newMembershipTO);
        }
        return result;
    }

    public static UserTO patch(UserTO userTO, UserPatch userPatch) {
        UserTO result = (UserTO)SerializationUtils.clone((Serializable)userTO);
        AnyOperations.patch(userTO, userPatch, result);
        if (userPatch.getPassword() != null) {
            result.setPassword((String)userPatch.getPassword().getValue());
        }
        if (userPatch.getUsername() != null) {
            result.setUsername((String)userPatch.getUsername().getValue());
        }
        for (RelationshipPatch relPatch : userPatch.getRelationships()) {
            if (relPatch.getRelationshipTO() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)RelationshipPatch.class.getName(), (Object)relPatch);
                continue;
            }
            result.getRelationships().remove(relPatch.getRelationshipTO());
            if (relPatch.getOperation() != PatchOperation.ADD_REPLACE) continue;
            result.getRelationships().add(relPatch.getRelationshipTO());
        }
        for (final MembershipPatch membPatch : userPatch.getMemberships()) {
            if (membPatch.getGroup() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)MembershipPatch.class.getName(), (Object)membPatch);
                continue;
            }
            MembershipTO memb = (MembershipTO)IterableUtils.find(result.getMemberships(), (Predicate)new Predicate<MembershipTO>(){

                public boolean evaluate(MembershipTO object) {
                    return membPatch.getGroup().equals(object.getGroupKey());
                }
            });
            if (memb != null) {
                result.getMemberships().remove(memb);
            }
            if (membPatch.getOperation() != PatchOperation.ADD_REPLACE) continue;
            MembershipTO newMembershipTO = new MembershipTO();
            newMembershipTO.setGroupKey(membPatch.getGroup());
            if (memb == null) {
                for (AttrPatch attrPatch : membPatch.getPlainAttrs()) {
                    newMembershipTO.getPlainAttrs().add(attrPatch.getAttrTO());
                }
            } else {
                newMembershipTO.getPlainAttrs().addAll(AnyOperations.patch(memb.getPlainAttrMap(), membPatch.getPlainAttrs()));
            }
            newMembershipTO.getVirAttrs().addAll(membPatch.getVirAttrs());
            result.getMemberships().add(newMembershipTO);
        }
        block6: for (StringPatchItem rolePatch : userPatch.getRoles()) {
            switch (rolePatch.getOperation()) {
                case ADD_REPLACE: {
                    result.getRoles().add((String)rolePatch.getValue());
                    continue block6;
                }
            }
            result.getRoles().remove(rolePatch.getValue());
        }
        return result;
    }
}

