/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;

@XmlRootElement(name="user")
@XmlType
@Schema(allOf={AnyTO.class})
public class UserTO
extends AnyTO
implements GroupableRelatableTO {
    private static final long serialVersionUID = 7791304495192615740L;
    private String password;
    private final List<String> roles = new ArrayList<String>();
    private final List<String> dynRoles = new ArrayList<String>();
    private final Set<String> privileges = new TreeSet<String>();
    private String token;
    private Date tokenExpireTime;
    private String username;
    private Date lastLoginDate;
    private Date changePwdDate;
    private Integer failedLogins;
    private String securityQuestion;
    private String securityAnswer;
    private boolean suspended;
    private boolean mustChangePassword;
    private final List<RelationshipTO> relationships = new ArrayList<RelationshipTO>();
    private final List<MembershipTO> memberships = new ArrayList<MembershipTO>();
    private final List<MembershipTO> dynMemberships = new ArrayList<MembershipTO>();
    private final List<LinkedAccountTO> linkedAccounts = new ArrayList<LinkedAccountTO>();
    private final List<String> delegatingDelegations = new ArrayList<String>();
    private final List<String> delegatedDelegations = new ArrayList<String>();

    @Override
    @JsonProperty(value="@class")
    @Schema(name="@class", required=true, example="org.apache.syncope.common.lib.to.UserTO")
    public String getDiscriminator() {
        return this.getClass().getName();
    }

    @Override
    public String getType() {
        return AnyTypeKind.USER.name();
    }

    @Override
    public void setType(String type) {
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @XmlElementWrapper(name="roles")
    @XmlElement(name="role")
    @JsonProperty(value="roles")
    public List<String> getRoles() {
        return this.roles;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @XmlElementWrapper(name="dynRoles")
    @XmlElement(name="role")
    @JsonProperty(value="dynRoles")
    public List<String> getDynRoles() {
        return this.dynRoles;
    }

    @XmlElementWrapper(name="privileges")
    @XmlElement(name="privilege")
    @JsonProperty(value="privileges")
    public Set<String> getPrivileges() {
        return this.privileges;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public Date getTokenExpireTime() {
        if (this.tokenExpireTime != null) {
            return new Date(this.tokenExpireTime.getTime());
        }
        return null;
    }

    public void setTokenExpireTime(Date tokenExpireTime) {
        this.tokenExpireTime = tokenExpireTime != null ? new Date(tokenExpireTime.getTime()) : null;
    }

    @JsonProperty(required=true)
    @XmlElement(required=true)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public Date getChangePwdDate() {
        if (this.changePwdDate != null) {
            return new Date(this.changePwdDate.getTime());
        }
        return null;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public Integer getFailedLogins() {
        return this.failedLogins;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public Date getLastLoginDate() {
        if (this.lastLoginDate != null) {
            return new Date(this.lastLoginDate.getTime());
        }
        return null;
    }

    public void setChangePwdDate(Date changePwdDate) {
        this.changePwdDate = changePwdDate != null ? new Date(changePwdDate.getTime()) : null;
    }

    public void setFailedLogins(Integer failedLogins) {
        this.failedLogins = failedLogins;
    }

    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate != null ? new Date(lastLoginDate.getTime()) : null;
    }

    public String getSecurityQuestion() {
        return this.securityQuestion;
    }

    public void setSecurityQuestion(String securityQuestion) {
        this.securityQuestion = securityQuestion;
    }

    public String getSecurityAnswer() {
        return this.securityAnswer;
    }

    public void setSecurityAnswer(String securityAnswer) {
        this.securityAnswer = securityAnswer;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isMustChangePassword() {
        return this.mustChangePassword;
    }

    public void setMustChangePassword(boolean mustChangePassword) {
        this.mustChangePassword = mustChangePassword;
    }

    @Override
    @JsonIgnore
    public Optional<RelationshipTO> getRelationship(String type, String otherKey) {
        return this.relationships.stream().filter(relationship -> type.equals(relationship.getType()) && otherKey.equals(relationship.getOtherEndKey())).findFirst();
    }

    @Override
    @XmlElementWrapper(name="relationships")
    @XmlElement(name="relationship")
    @JsonProperty(value="relationships")
    public List<RelationshipTO> getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonIgnore
    public Optional<MembershipTO> getMembership(String groupKey) {
        return this.memberships.stream().filter(membership -> groupKey.equals(membership.getGroupKey())).findFirst();
    }

    @Override
    @XmlElementWrapper(name="memberships")
    @XmlElement(name="membership")
    @JsonProperty(value="memberships")
    public List<MembershipTO> getMemberships() {
        return this.memberships;
    }

    @Override
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @XmlElementWrapper(name="dynMemberships")
    @XmlElement(name="dynMembership")
    @JsonProperty(value="dynMemberships")
    public List<MembershipTO> getDynMemberships() {
        return this.dynMemberships;
    }

    @XmlElementWrapper(name="linkedAccounts")
    @XmlElement(name="linkedAccount")
    @JsonProperty(value="linkedAccounts")
    public List<LinkedAccountTO> getLinkedAccounts() {
        return this.linkedAccounts;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @XmlElementWrapper(name="delegatingDelegations")
    @XmlElement(name="delegatingDelegation")
    @JsonProperty(value="delegatingDelegations")
    public List<String> getDelegatingDelegations() {
        return this.delegatingDelegations;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @XmlElementWrapper(name="delegatedDelegations")
    @XmlElement(name="delegatedDelegation")
    @JsonProperty(value="delegatedDelegations")
    public List<String> getDelegatedDelegations() {
        return this.delegatedDelegations;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.username).append(this.roles).append(this.dynRoles).append(this.privileges).append((Object)this.token).append((Object)this.tokenExpireTime).append((Object)this.lastLoginDate).append((Object)this.changePwdDate).append((Object)this.failedLogins).append((Object)this.securityQuestion).append((Object)this.securityAnswer).append(this.suspended).append(this.mustChangePassword).append(this.relationships).append(this.memberships).append(this.dynMemberships).append(this.linkedAccounts).append(this.delegatingDelegations).append(this.delegatedDelegations).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserTO other = (UserTO)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.username, (Object)other.username).append(this.roles, other.roles).append(this.dynRoles, other.dynRoles).append(this.privileges, other.privileges).append((Object)this.token, (Object)other.token).append((Object)this.tokenExpireTime, (Object)other.tokenExpireTime).append((Object)this.lastLoginDate, (Object)other.lastLoginDate).append((Object)this.changePwdDate, (Object)other.changePwdDate).append((Object)this.failedLogins, (Object)other.failedLogins).append((Object)this.securityQuestion, (Object)other.securityQuestion).append((Object)this.securityAnswer, (Object)other.securityAnswer).append(this.suspended, other.suspended).append(this.mustChangePassword, other.mustChangePassword).append(this.relationships, other.relationships).append(this.memberships, other.memberships).append(this.dynMemberships, other.dynMemberships).append(this.linkedAccounts, other.linkedAccounts).append(this.delegatingDelegations, other.delegatingDelegations).append(this.delegatedDelegations, other.delegatedDelegations).build();
    }
}

