/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.common.lib.policy;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name = "defaultPullCorrelationRuleConf")
@XmlType
public class DefaultPullCorrelationRuleConf extends AbstractCorrelationRuleConf implements PullCorrelationRuleConf {

    private static final long serialVersionUID = 429126085793346273L;

    private boolean orSchemas;

    private final List<String> schemas = new ArrayList<>();

    public boolean isOrSchemas() {
        return orSchemas;
    }

    public void setOrSchemas(final boolean orSchemas) {
        this.orSchemas = orSchemas;
    }

    @XmlElementWrapper(name = "schemas")
    @XmlElement(name = "schema")
    @JsonProperty("schemas")
    public List<String> getSchemas() {
        return schemas;
    }
}
