/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ItemContainerTO;
import org.apache.syncope.common.lib.to.ItemTO;

@XmlRootElement(name="orgUnit")
@XmlType
public class OrgUnitTO
implements EntityTO,
ItemContainerTO {
    private static final long serialVersionUID = -1868877794174953177L;
    private String key;
    private String objectClass;
    private String syncToken;
    private boolean ignoreCaseMatch;
    private String connObjectLink;
    private final List<ItemTO> items = new ArrayList<ItemTO>();

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    public String getSyncToken() {
        return this.syncToken;
    }

    public void setSyncToken(String syncToken) {
        this.syncToken = syncToken;
    }

    public boolean isIgnoreCaseMatch() {
        return this.ignoreCaseMatch;
    }

    public void setIgnoreCaseMatch(boolean ignoreCaseMatch) {
        this.ignoreCaseMatch = ignoreCaseMatch;
    }

    public String getConnObjectLink() {
        return this.connObjectLink;
    }

    public void setConnObjectLink(String connObjectLink) {
        this.connObjectLink = connObjectLink;
    }

    @Override
    public ItemTO getConnObjectKeyItem() {
        return this.getItems().stream().filter(item -> item.isConnObjectKey()).findFirst().orElse(null);
    }

    protected boolean addConnObjectKeyItem(ItemTO connObjectItem) {
        connObjectItem.setMandatoryCondition("true");
        connObjectItem.setConnObjectKey(true);
        return this.add(connObjectItem);
    }

    @Override
    public boolean setConnObjectKeyItem(ItemTO connObjectKeyItem) {
        return connObjectKeyItem == null ? this.remove(this.getConnObjectKeyItem()) : this.addConnObjectKeyItem(connObjectKeyItem);
    }

    @Override
    @XmlElementWrapper(name="items")
    @XmlElement(name="item")
    @JsonProperty(value="items")
    public List<ItemTO> getItems() {
        return this.items;
    }

    @Override
    public boolean add(ItemTO item) {
        return item == null ? false : this.items.contains(item) || this.items.add(item);
    }

    public boolean remove(ItemTO item) {
        return this.items.remove(item);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrgUnitTO other = (OrgUnitTO)obj;
        return new EqualsBuilder().append(this.ignoreCaseMatch, other.ignoreCaseMatch).append((Object)this.key, (Object)other.key).append((Object)this.objectClass, (Object)other.objectClass).append((Object)this.syncToken, (Object)other.syncToken).append((Object)this.connObjectLink, (Object)other.connObjectLink).append(this.items, other.items).build();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.key).append((Object)this.objectClass).append((Object)this.syncToken).append(this.ignoreCaseMatch).append((Object)this.connObjectLink).append(this.items).build();
    }
}

