/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.beans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.types.SchemaType;

public class SchemaQuery
extends AbstractBaseBean {
    private static final long serialVersionUID = -1863334226169614417L;
    private SchemaType type;
    private List<String> anyTypeClasses;

    public SchemaType getType() {
        return this.type;
    }

    @NotNull
    @PathParam(value="type")
    public void setType(SchemaType type) {
        this.type = type;
    }

    public List<String> getAnyTypeClasses() {
        return this.anyTypeClasses;
    }

    @QueryParam(value="anyTypeClass")
    public void setAnyTypeClasses(List<String> anyTypeClasses) {
        this.anyTypeClasses = anyTypeClasses;
    }

    public static class Builder {
        private final SchemaQuery instance = new SchemaQuery();

        public Builder type(SchemaType type) {
            this.instance.setType(type);
            return this;
        }

        public Builder anyTypeClass(String anyTypeClass) {
            if (this.instance.getAnyTypeClasses() == null) {
                this.instance.setAnyTypeClasses(new ArrayList<String>());
            }
            this.instance.getAnyTypeClasses().add(anyTypeClass);
            return this;
        }

        public Builder anyTypeClasses(Collection<String> anyTypeClasses) {
            for (String anyTypeClass : anyTypeClasses) {
                this.anyTypeClass(anyTypeClass);
            }
            return this;
        }

        public Builder anyTypeClasses(String ... anyTypeClasses) {
            return this.anyTypeClasses(Arrays.asList(anyTypeClasses));
        }

        public SchemaQuery build() {
            if (this.instance.type == null) {
                throw new IllegalArgumentException("type is required");
            }
            return this.instance;
        }
    }
}

