/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.ResponseHeader;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.AccessTokenTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.rest.api.beans.AccessTokenQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Api(tags={"AccessTokens"})
@Path(value="accessTokens")
public interface AccessTokenService
extends JAXRSService {
    @ApiOperation(value="", authorizations={@Authorization(value="BasicAuthentication")})
    @ApiResponses(value={@ApiResponse(code=204, message="JWT successfully generated", responseHeaders={@ResponseHeader(name="X-Syncope-Token", response=String.class, description="Generated JWT"), @ResponseHeader(name="X-Syncope-Token-Expire", response=String.class, description="Expiration of the generated JWT")}), @ApiResponse(code=401, message="Invalid username or password")})
    @POST
    @Path(value="login")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response login();

    @ApiOperation(value="", authorizations={@Authorization(value="Bearer")})
    @ApiResponses(value={@ApiResponse(code=204, message="JWT successfully refreshed", responseHeaders={@ResponseHeader(name="X-Syncope-Token", response=String.class, description="Generated JWT"), @ResponseHeader(name="X-Syncope-Token-Expire", response=String.class, description="Expiration of the refreshed JWT")})})
    @POST
    @Path(value="refresh")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response refresh();

    @ApiOperation(value="", authorizations={@Authorization(value="Bearer")})
    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @POST
    @Path(value="logout")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void logout();

    @ApiOperation(value="", authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
    @GET
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public PagedResult<AccessTokenTO> list(@BeanParam AccessTokenQuery var1);

    @ApiOperation(value="", authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@PathParam(value="key") String var1);
}

