/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.patch.AssociationPatch;
import org.apache.syncope.common.lib.patch.DeassociationPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.BulkAction;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

public interface AnyService<TO extends AnyTO>
extends JAXRSService {
    @GET
    @Path(value="{key}/{schemaType}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Set<AttrTO> read(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="schemaType") SchemaType var2);

    @GET
    @Path(value="{key}/{schemaType}/{schema}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public AttrTO read(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="schemaType") SchemaType var2, @NotNull @PathParam(value="schema") String var3);

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public TO read(@NotNull @PathParam(value="key") String var1);

    @GET
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public PagedResult<TO> search(@BeanParam AnyQuery var1);

    @ApiImplicitParams(value={@ApiImplicitParam(name="schema", paramType="path", dataType="string", value="Attribute schema's key")})
    @PUT
    @Path(value="{key}/{schemaType}/{schema}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response update(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="schemaType") SchemaType var2, @NotNull AttrTO var3);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @DELETE
    @Path(value="{key}/{schemaType}/{schema}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="schemaType") SchemaType var2, @NotNull @PathParam(value="schema") String var3);

    @ApiImplicitParams(value={@ApiImplicitParam(name="Prefer", paramType="header", dataType="string", value="Allows the client to specify a preference for the result to be returned from the server", defaultValue="return-content", allowableValues="return-content, return-no-content", allowEmptyValue=true), @ApiImplicitParam(name="If-Match", paramType="header", dataType="string", value="When the provided ETag value does not match the latest modification date of the entity, an error is reported and the requested operation is not performed.", allowEmptyValue=true), @ApiImplicitParam(name="X-Syncope-Null-Priority-Async", paramType="header", dataType="boolean", value="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", defaultValue="false", allowEmptyValue=true)})
    @ApiResponses(value={@ApiResponse(code=200, message="User, Group or Any Object successfully deleted enriched with propagation status information, as Entity", response=ProvisioningResult.class), @ApiResponse(code=204, message="No content if 'Prefer: return-no-content' was specified", responseHeaders={@ResponseHeader(name="Preference-Applied", response=String.class, description="Allows the server to inform the client about the fact that a specified preference was applied")}), @ApiResponse(code=412, message="The ETag value provided via the 'If-Match' header does not match the latest modification date of the entity")})
    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response delete(@NotNull @PathParam(value="key") String var1);

    @ApiImplicitParams(value={@ApiImplicitParam(name="Prefer", paramType="header", dataType="string", value="Allows the client to specify a preference for the result to be returned from the server", defaultValue="return-content", allowableValues="return-content, return-no-content", allowEmptyValue=true), @ApiImplicitParam(name="If-Match", paramType="header", dataType="string", value="When the provided ETag value does not match the latest modification date of the entity, an error is reported and the requested operation is not performed.", allowEmptyValue=true), @ApiImplicitParam(name="X-Syncope-Null-Priority-Async", paramType="header", dataType="boolean", value="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", defaultValue="false", allowEmptyValue=true), @ApiImplicitParam(name="key", paramType="path", dataType="string", value="Entity's key"), @ApiImplicitParam(name="action", paramType="path", dataType="string", allowableValues="UNLINK,DEPROVISION,UNASSIGN", value="Deassociation action")})
    @ApiResponses(value={@ApiResponse(code=200, message="Bulk action result", response=BulkActionResult.class), @ApiResponse(code=204, message="No content if 'Prefer: return-no-content' was specified", responseHeaders={@ResponseHeader(name="Preference-Applied", response=String.class, description="Allows the server to inform the client about the fact that a specified preference was applied")}), @ApiResponse(code=412, message="The ETag value provided via the 'If-Match' header does not match the latest modification date of the entity")})
    @POST
    @Path(value="{key}/deassociate/{action}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response deassociate(@NotNull DeassociationPatch var1);

    @ApiImplicitParams(value={@ApiImplicitParam(name="Prefer", paramType="header", dataType="string", value="Allows the client to specify a preference for the result to be returned from the server", defaultValue="return-content", allowableValues="return-content, return-no-content", allowEmptyValue=true), @ApiImplicitParam(name="If-Match", paramType="header", dataType="string", value="When the provided ETag value does not match the latest modification date of the entity, an error is reported and the requested operation is not performed.", allowEmptyValue=true), @ApiImplicitParam(name="X-Syncope-Null-Priority-Async", paramType="header", dataType="boolean", value="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", defaultValue="false", allowEmptyValue=true), @ApiImplicitParam(name="key", paramType="path", dataType="string", value="Entity's key"), @ApiImplicitParam(name="action", paramType="path", dataType="string", allowableValues="LINK,PROVISION,ASSIGN", value="Association action")})
    @ApiResponses(value={@ApiResponse(code=200, message="Bulk action result", response=BulkActionResult.class), @ApiResponse(code=204, message="No content if 'Prefer: return-no-content' was specified", responseHeaders={@ResponseHeader(name="Preference-Applied", response=String.class, description="Allows the server to inform the client about the fact that a specified preference was applied")}), @ApiResponse(code=412, message="The ETag value provided via the 'If-Match' header does not match the latest modification date of the entity")})
    @POST
    @Path(value="{key}/associate/{action}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response associate(@NotNull AssociationPatch var1);

    @ApiImplicitParams(value={@ApiImplicitParam(name="Prefer", paramType="header", dataType="string", value="Allows the client to specify a preference for the result to be returned from the server", defaultValue="return-content", allowableValues="return-content, return-no-content", allowEmptyValue=true), @ApiImplicitParam(name="X-Syncope-Null-Priority-Async", paramType="header", dataType="boolean", value="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", defaultValue="false", allowEmptyValue=true)})
    @ApiResponses(value={@ApiResponse(code=200, message="Bulk action result", response=BulkActionResult.class), @ApiResponse(code=204, message="No content if 'Prefer: return-no-content' was specified", responseHeaders={@ResponseHeader(name="Preference-Applied", response=String.class, description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @POST
    @Path(value="bulk")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response bulk(@NotNull BulkAction var1);
}

