/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.ResponseHeader;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.PATCH;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.BulkMembersActionType;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.service.AnyService;

@Api(tags={"Groups"}, authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
@Path(value="groups")
public interface GroupService
extends AnyService<GroupTO> {
    @Override
    @ApiResponses(value={@ApiResponse(code=200, message="Group matching the provided key; if value looks like a UUID then it is interpreted as key, otherwise as a name.", responseHeaders={@ResponseHeader(name="ETag", response=String.class, description="Opaque identifier for the latest modification made to the entity returned by this endpoint")})})
    public GroupTO read(String var1);

    @Override
    public PagedResult<GroupTO> search(AnyQuery var1);

    @ApiImplicitParams(value={@ApiImplicitParam(name="Prefer", paramType="header", dataType="string", value="Allows the client to specify a preference for the result to be returned from the server", defaultValue="return-content", allowableValues="return-content, return-no-content", allowEmptyValue=true), @ApiImplicitParam(name="X-Syncope-Null-Priority-Async", paramType="header", dataType="boolean", value="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", defaultValue="false", allowEmptyValue=true)})
    @ApiResponses(value={@ApiResponse(code=201, message="Group successfully created enriched with propagation status information, as Entity,or empty if 'Prefer: return-no-content' was specified", response=ProvisioningResult.class, responseHeaders={@ResponseHeader(name="X-Syncope-Key", response=String.class, description="UUID generated for the group created"), @ResponseHeader(name="Location", response=String.class, description="URL of the group created"), @ResponseHeader(name="Preference-Applied", response=String.class, description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @POST
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response create(@NotNull GroupTO var1);

    @ApiImplicitParams(value={@ApiImplicitParam(name="Prefer", paramType="header", dataType="string", value="Allows the client to specify a preference for the result to be returned from the server", defaultValue="return-content", allowableValues="return-content, return-no-content", allowEmptyValue=true), @ApiImplicitParam(name="If-Match", paramType="header", dataType="string", value="When the provided ETag value does not match the latest modification date of the entity, an error is reported and the requested operation is not performed.", allowEmptyValue=true), @ApiImplicitParam(name="X-Syncope-Null-Priority-Async", paramType="header", dataType="boolean", value="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", defaultValue="false", allowEmptyValue=true), @ApiImplicitParam(name="key", paramType="path", dataType="string", value="Group's key")})
    @ApiResponses(value={@ApiResponse(code=200, message="Group successfully updated enriched with propagation status information, as Entity", response=ProvisioningResult.class), @ApiResponse(code=204, message="No content if 'Prefer: return-no-content' was specified", responseHeaders={@ResponseHeader(name="Preference-Applied", response=String.class, description="Allows the server to inform the client about the fact that a specified preference was applied")}), @ApiResponse(code=412, message="The ETag value provided via the 'If-Match' header does not match the latest modification date of the entity")})
    @PATCH
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response update(@NotNull GroupPatch var1);

    @ApiImplicitParams(value={@ApiImplicitParam(name="Prefer", paramType="header", dataType="string", value="Allows the client to specify a preference for the result to be returned from the server", defaultValue="return-content", allowableValues="return-content, return-no-content", allowEmptyValue=true), @ApiImplicitParam(name="If-Match", paramType="header", dataType="string", value="When the provided ETag value does not match the latest modification date of the entity, an error is reported and the requested operation is not performed.", allowEmptyValue=true), @ApiImplicitParam(name="X-Syncope-Null-Priority-Async", paramType="header", dataType="boolean", value="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", defaultValue="false", allowEmptyValue=true), @ApiImplicitParam(name="key", paramType="path", dataType="string", value="Group's key")})
    @ApiResponses(value={@ApiResponse(code=200, message="Group successfully updated enriched with propagation status information, as Entity", response=ProvisioningResult.class), @ApiResponse(code=204, message="No content if 'Prefer: return-no-content' was specified", responseHeaders={@ResponseHeader(name="Preference-Applied", response=String.class, description="Allows the server to inform the client about the fact that a specified preference was applied")}), @ApiResponse(code=412, message="The ETag value provided via the 'If-Match' header does not match the latest modification date of the entity")})
    @PUT
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response update(@NotNull GroupTO var1);

    @GET
    @Path(value="own")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<GroupTO> own();

    @POST
    @Path(value="{key}/members/{actionType}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public ExecTO bulkMembersAction(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="actionType") BulkMembersActionType var2);
}

