/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.ResponseHeader;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.NotificationTO;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Api(tags={"Notifications"}, authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
@Path(value="notifications")
public interface NotificationService
extends JAXRSService {
    @GET
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public NotificationTO read(@NotNull @PathParam(value="key") String var1);

    @GET
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<NotificationTO> list();

    @ApiResponses(value={@ApiResponse(code=201, message="Notification successfully created", responseHeaders={@ResponseHeader(name="X-Syncope-Key", response=String.class, description="UUID generated for the entity created"), @ResponseHeader(name="Location", response=String.class, description="URL of the entity created")})})
    @POST
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response create(@NotNull NotificationTO var1);

    @ApiImplicitParams(value={@ApiImplicitParam(name="key", paramType="path", dataType="string", value="Notifications's key")})
    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @PUT
    @Path(value="{key}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void update(@NotNull NotificationTO var1);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@NotNull @PathParam(value="key") String var1);

    @GET
    @Path(value="job")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public JobTO getJob();

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @POST
    @Path(value="job")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void actionJob(@QueryParam(value="action") JobAction var1);
}

