/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.ResponseHeader;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Api(tags={"Realms"}, authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
@Path(value="realms")
public interface RealmService
extends JAXRSService {
    @GET
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<RealmTO> list();

    @GET
    @Path(value="{fullPath:.*}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<RealmTO> list(@NotNull @PathParam(value="fullPath") String var1);

    @ApiImplicitParams(value={@ApiImplicitParam(name="Prefer", paramType="header", dataType="string", value="Allows the client to specify a preference for the result to be returned from the server", defaultValue="return-content", allowableValues="return-content, return-no-content", allowEmptyValue=true), @ApiImplicitParam(name="X-Syncope-Null-Priority-Async", paramType="header", dataType="boolean", value="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", defaultValue="false", allowEmptyValue=true)})
    @ApiResponses(value={@ApiResponse(code=201, message="Realm successfully created enriched with propagation status information, as Entity,or empty if 'Prefer: return-no-content' was specified", response=ProvisioningResult.class, responseHeaders={@ResponseHeader(name="X-Syncope-Key", response=String.class, description="UUID generated for the realm created"), @ResponseHeader(name="Location", response=String.class, description="URL of the realm created"), @ResponseHeader(name="Preference-Applied", response=String.class, description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @POST
    @Path(value="{parentPath:.*}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response create(@NotNull @PathParam(value="parentPath") String var1, @NotNull RealmTO var2);

    @ApiImplicitParams(value={@ApiImplicitParam(name="Prefer", paramType="header", dataType="string", value="Allows the client to specify a preference for the result to be returned from the server", defaultValue="return-content", allowableValues="return-content, return-no-content", allowEmptyValue=true), @ApiImplicitParam(name="X-Syncope-Null-Priority-Async", paramType="header", dataType="boolean", value="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", defaultValue="false", allowEmptyValue=true), @ApiImplicitParam(name="fullPath", paramType="path", dataType="string", value="Realm's fullPath")})
    @ApiResponses(value={@ApiResponse(code=200, message="Realm successfully updated enriched with propagation status information, as Entity", response=ProvisioningResult.class), @ApiResponse(code=204, message="No content if 'Prefer: return-no-content' was specified", responseHeaders={@ResponseHeader(name="Preference-Applied", response=String.class, description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @PUT
    @Path(value="{fullPath:.*}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response update(@NotNull RealmTO var1);

    @ApiImplicitParams(value={@ApiImplicitParam(name="Prefer", paramType="header", dataType="string", value="Allows the client to specify a preference for the result to be returned from the server", defaultValue="return-content", allowableValues="return-content, return-no-content", allowEmptyValue=true), @ApiImplicitParam(name="X-Syncope-Null-Priority-Async", paramType="header", dataType="boolean", value="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", defaultValue="false", allowEmptyValue=true)})
    @ApiResponses(value={@ApiResponse(code=200, message="Realm successfully deleted enriched with propagation status information, as Entity", response=ProvisioningResult.class), @ApiResponse(code=204, message="No content if 'Prefer: return-no-content' was specified", responseHeaders={@ResponseHeader(name="Preference-Applied", response=String.class, description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @DELETE
    @Path(value="{fullPath:.*}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response delete(@NotNull @PathParam(value="fullPath") String var1);
}

