/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.beans;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.rest.api.beans.AbstractQuery;

public class TaskQuery
extends AbstractQuery {
    private static final long serialVersionUID = -8792519310029596796L;
    private TaskType type;
    private String resource;
    private String notification;
    private AnyTypeKind anyTypeKind;
    private String entityKey;
    private Boolean details;

    public TaskType getType() {
        return this.type;
    }

    @NotNull
    @PathParam(value="type")
    public void setType(TaskType type) {
        this.type = type;
    }

    @Parameter(name="resource", description="resource key to match", schema=@Schema(implementation=String.class, example="resource-ldap"))
    public String getResource() {
        return this.resource;
    }

    @QueryParam(value="resource")
    public void setResource(String resource) {
        this.resource = resource;
    }

    @Parameter(name="notification", description="notification key to match", schema=@Schema(implementation=String.class, example="4bf255f1-85a0-43d6-8988-128dad646f08"))
    public String getNotification() {
        return this.notification;
    }

    @QueryParam(value="notification")
    public void setNotification(String notification) {
        this.notification = notification;
    }

    @Parameter(name="anyTypeKind", description="entity type to match", schema=@Schema(implementation=AnyTypeKind.class))
    public AnyTypeKind getAnyTypeKind() {
        return this.anyTypeKind;
    }

    @QueryParam(value="anyTypeKind")
    public void setAnyTypeKind(AnyTypeKind anyTypeKind) {
        this.anyTypeKind = anyTypeKind;
    }

    @Parameter(name="entityKey", description="entity key to match", schema=@Schema(implementation=String.class, example="50592942-73ec-44c4-a377-e859524245e4"))
    public String getEntityKey() {
        return this.entityKey;
    }

    @QueryParam(value="entityKey")
    public void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }

    @Parameter(name="details", description="whether detailed information about executions is to be included", schema=@Schema(implementation=Boolean.class))
    public Boolean getDetails() {
        return this.details == null ? Boolean.TRUE : this.details;
    }

    @QueryParam(value="details")
    @DefaultValue(value="true")
    public void setDetails(Boolean details) {
        this.details = details;
    }

    public static class Builder
    extends AbstractQuery.Builder<TaskQuery, Builder> {
        public Builder(TaskType type) {
            ((TaskQuery)this.getInstance()).setType(type);
        }

        @Override
        protected TaskQuery newInstance() {
            return new TaskQuery();
        }

        public Builder resource(String resource) {
            ((TaskQuery)this.getInstance()).setResource(resource);
            return this;
        }

        public Builder notification(String notification) {
            ((TaskQuery)this.getInstance()).setNotification(notification);
            return this;
        }

        public Builder anyTypeKind(AnyTypeKind anyTypeKind) {
            ((TaskQuery)this.getInstance()).setAnyTypeKind(anyTypeKind);
            return this;
        }

        public Builder entityKey(String entityKey) {
            ((TaskQuery)this.getInstance()).setEntityKey(entityKey);
            return this;
        }

        public Builder details(boolean details) {
            ((TaskQuery)this.getInstance()).setDetails(details);
            return this;
        }
    }
}

