/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.beans;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.QueryParam;

public class ConnObjectTOQuery
implements Serializable {
    private static final long serialVersionUID = -371488230250055359L;
    private static final int MAX_SIZE = 100;
    private Integer size;
    private String pagedResultsCookie;
    private String orderBy;
    private String fiql;
    private Set<String> moreAttrsToGet;

    public Integer getSize() {
        return this.size == null ? 25 : (this.size > 100 ? 100 : this.size);
    }

    @Min(value=1L)
    @Max(value=100L)
    @QueryParam(value="size")
    @DefaultValue(value="25")
    public void setSize(Integer size) {
        this.size = size;
    }

    public String getPagedResultsCookie() {
        return this.pagedResultsCookie;
    }

    @QueryParam(value="connIdPagedResultsCookie")
    public void setPagedResultsCookie(String pagedResultsCookie) {
        this.pagedResultsCookie = pagedResultsCookie;
    }

    @QueryParam(value="orderby")
    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getFiql() {
        return this.fiql;
    }

    @QueryParam(value="fiql")
    public void setFiql(String fiql) {
        this.fiql = fiql;
    }

    public Set<String> getMoreAttrsToGet() {
        return this.moreAttrsToGet;
    }

    @QueryParam(value="moreAttrsToGet")
    public void setMoreAttrsToGet(Set<String> moreAttrsToGet) {
        this.moreAttrsToGet = moreAttrsToGet;
    }

    public static class Builder {
        private final ConnObjectTOQuery instance = new ConnObjectTOQuery();

        public Builder size(Integer size) {
            this.instance.setSize(size);
            return this;
        }

        public Builder pagedResultsCookie(String pagedResultsCookie) {
            this.instance.setPagedResultsCookie(pagedResultsCookie);
            return this;
        }

        public Builder orderBy(String orderBy) {
            this.instance.setOrderBy(orderBy);
            return this;
        }

        public Builder fiql(String fiql) {
            this.instance.setFiql(fiql);
            return this;
        }

        public Builder moreAttrsToGet(String ... moreAttrsToGet) {
            if (moreAttrsToGet != null) {
                Set matg = Optional.ofNullable(this.instance.getMoreAttrsToGet()).orElseGet(() -> new HashSet());
                matg.addAll(Stream.of(moreAttrsToGet).collect(Collectors.toSet()));
                this.instance.setMoreAttrsToGet(matg);
            }
            return this;
        }

        public Builder moreAttrsToGet(Collection<String> moreAttrsToGet) {
            if (moreAttrsToGet != null) {
                Set matg = Optional.ofNullable(this.instance.getMoreAttrsToGet()).orElseGet(() -> new HashSet());
                matg.addAll(moreAttrsToGet);
                this.instance.setMoreAttrsToGet(matg);
            }
            return this;
        }

        public ConnObjectTOQuery build() {
            return this.instance;
        }
    }
}

