/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.batch;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.syncope.common.rest.api.batch.BatchPayloadLine;

public class BatchPayloadLineReader
implements AutoCloseable {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final int EOF = -1;
    private static final int BUFFER_SIZE = 8192;
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final ReadState readState = new ReadState();
    private final InputStream in;
    private final MediaType multipartMixed;
    private final byte[] buffer = new byte[8192];
    private Charset currentCharset = DEFAULT_CHARSET;
    private String currentBoundary = null;
    private int offset = 0;
    private int limit = 0;

    public BatchPayloadLineReader(InputStream in, MediaType multipartMixed) {
        this.in = in;
        this.multipartMixed = multipartMixed;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private boolean isBoundary(String currentLine) {
        return (this.currentBoundary + "\r\n").equals(currentLine) || (this.currentBoundary + "--" + "\r\n").equals(currentLine);
    }

    private int fillBuffer() throws IOException {
        this.limit = this.in.read(this.buffer, 0, this.buffer.length);
        this.offset = 0;
        return this.limit;
    }

    private String readLine() throws IOException {
        if (this.limit == -1) {
            return null;
        }
        ByteBuffer innerBuffer = ByteBuffer.allocate(8192);
        boolean foundLineEnd = false;
        while (!foundLineEnd) {
            if (this.limit == this.offset && this.fillBuffer() == -1) {
                foundLineEnd = true;
            }
            if (foundLineEnd) continue;
            byte currentChar = this.buffer[this.offset++];
            if (!innerBuffer.hasRemaining()) {
                innerBuffer.flip();
                ByteBuffer tmp = ByteBuffer.allocate(innerBuffer.limit() * 2);
                tmp.put(innerBuffer);
                innerBuffer = tmp;
            }
            innerBuffer.put(currentChar);
            if (currentChar == 10) {
                foundLineEnd = true;
                continue;
            }
            if (currentChar != 13) continue;
            foundLineEnd = true;
            if (this.limit == this.offset) {
                this.fillBuffer();
            }
            if (this.limit == -1 || this.buffer[this.offset] != 10) continue;
            innerBuffer.put((byte)10);
            ++this.offset;
        }
        if (innerBuffer.position() == 0) {
            return null;
        }
        String currentLine = new String(innerBuffer.array(), 0, innerBuffer.position(), this.readState.isReadBody() ? this.currentCharset : DEFAULT_CHARSET);
        if (currentLine.startsWith("Content-Type")) {
            String charsetString = (String)this.multipartMixed.getParameters().get("charset");
            this.currentCharset = charsetString == null ? DEFAULT_CHARSET : Charset.forName(charsetString);
            this.currentBoundary = "--" + (String)this.multipartMixed.getParameters().get("boundary");
        } else if ("\r\n".equals(currentLine)) {
            this.readState.foundLinebreak();
        } else if (this.isBoundary(currentLine)) {
            this.readState.foundBoundary();
        }
        return currentLine;
    }

    public List<BatchPayloadLine> read() throws IOException {
        ArrayList<BatchPayloadLine> result = new ArrayList<BatchPayloadLine>();
        String currentLine = this.readLine();
        if (currentLine != null) {
            this.currentBoundary = currentLine.trim();
            int counter = 1;
            result.add(new BatchPayloadLine(currentLine, counter++));
            while ((currentLine = this.readLine()) != null) {
                result.add(new BatchPayloadLine(currentLine, counter++));
            }
        }
        return result;
    }

    private static class ReadState {
        private int state = 0;

        private ReadState() {
        }

        public void foundLinebreak() {
            ++this.state;
        }

        public void foundBoundary() {
            this.state = 0;
        }

        public boolean isReadBody() {
            return this.state >= 2;
        }

        public String toString() {
            return String.valueOf(this.state);
        }
    }
}

