/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.beans;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import javax.ws.rs.QueryParam;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.rest.api.beans.AbstractCSVSpec;

public class CSVPullSpec
extends AbstractCSVSpec {
    private static final long serialVersionUID = -5079876176017613587L;
    private String destinationRealm = "/";
    private String keyColumn;
    private Set<String> ignoreColumns = new HashSet<String>();
    private boolean remediation;
    private ConflictResolutionAction conflictResolutionAction = ConflictResolutionAction.IGNORE;
    private String pullCorrelationRule;

    public String getDestinationRealm() {
        return this.destinationRealm;
    }

    @QueryParam(value="destinationRealm")
    public void setDestinationRealm(String destinationRealm) {
        this.destinationRealm = destinationRealm;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    @NotNull
    @QueryParam(value="keyColumn")
    public void setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
    }

    public Set<String> getIgnoreColumns() {
        return this.ignoreColumns;
    }

    @QueryParam(value="ignoreColumns")
    public void setIgnoreColumns(Set<String> ignoreColumns) {
        this.ignoreColumns = ignoreColumns;
    }

    public boolean isRemediation() {
        return this.remediation;
    }

    @QueryParam(value="remediation")
    public void setRemediation(boolean remediation) {
        this.remediation = remediation;
    }

    public ConflictResolutionAction getConflictResolutionAction() {
        return this.conflictResolutionAction;
    }

    @QueryParam(value="conflictResolutionAction")
    public void setConflictResolutionAction(ConflictResolutionAction conflictResolutionAction) {
        this.conflictResolutionAction = conflictResolutionAction;
    }

    public String getPullCorrelationRule() {
        return this.pullCorrelationRule;
    }

    @QueryParam(value="pullCorrelationRule")
    public void setPullCorrelationRule(String pullCorrelationRule) {
        this.pullCorrelationRule = pullCorrelationRule;
    }

    public static class Builder
    extends AbstractCSVSpec.Builder<CSVPullSpec, Builder> {
        @Override
        protected CSVPullSpec newInstance() {
            return new CSVPullSpec();
        }

        public Builder(String anyTypeKey, String keyColumn) {
            ((CSVPullSpec)this.getInstance()).setAnyTypeKey(anyTypeKey);
            ((CSVPullSpec)this.getInstance()).setKeyColumn(keyColumn);
        }

        public Builder remediation(boolean remediation) {
            ((CSVPullSpec)this.instance).setRemediation(remediation);
            return this;
        }

        public Builder ignoreColumns(String ... ignoreColumns) {
            ((CSVPullSpec)this.instance).getIgnoreColumns().addAll(Stream.of(ignoreColumns).collect(Collectors.toList()));
            return this;
        }

        public Builder destinationRealm(String destinationRealm) {
            ((CSVPullSpec)this.instance).setDestinationRealm(destinationRealm);
            return this;
        }

        public Builder conflictResolutionAction(ConflictResolutionAction conflictResolutionAction) {
            ((CSVPullSpec)this.instance).setConflictResolutionAction(conflictResolutionAction);
            return this;
        }

        public Builder pullCorrelationRule(String pullCorrelationRule) {
            ((CSVPullSpec)this.instance).setPullCorrelationRule(pullCorrelationRule);
            return this;
        }
    }
}

