/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.camel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.PollingConsumer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.model.RoutesDefinition;
import org.apache.syncope.core.persistence.api.dao.CamelRouteDAO;
import org.apache.syncope.core.provisioning.camel.SyncopeCamelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

abstract class AbstractCamelProvisioningManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCamelProvisioningManager.class);
    @Autowired
    protected CamelRouteDAO routeDAO;
    @Autowired
    protected SyncopeCamelContext contextFactory;
    protected RoutesDefinition routes;
    protected final Map<String, PollingConsumer> consumerMap = new HashMap<String, PollingConsumer>();
    protected final List<String> knownURIs = new ArrayList<String>();

    AbstractCamelProvisioningManager() {
    }

    protected void sendMessage(String uri, Object obj) {
        DefaultExchange exchange = new DefaultExchange(this.contextFactory.getCamelContext());
        DefaultMessage message = new DefaultMessage();
        message.setBody(obj);
        exchange.setIn((Message)message);
        ProducerTemplate template = this.contextFactory.getCamelContext().createProducerTemplate();
        template.send(uri, (Exchange)exchange);
    }

    protected void sendMessage(String uri, Object body, Map<String, Object> properties) {
        DefaultExchange exchange = new DefaultExchange(this.contextFactory.getCamelContext());
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            exchange.setProperty(property.getKey(), property.getValue());
            LOG.debug("Added property {}", (Object)property.getKey());
        }
        DefaultMessage message = new DefaultMessage();
        message.setBody(body);
        exchange.setIn((Message)message);
        ProducerTemplate template = this.contextFactory.getCamelContext().createProducerTemplate();
        template.send(uri, (Exchange)exchange);
    }

    protected PollingConsumer getConsumer(String uri) {
        if (!this.knownURIs.contains(uri)) {
            this.knownURIs.add(uri);
            Endpoint endpoint = this.contextFactory.getCamelContext().getEndpoint(uri);
            PollingConsumer pollingConsumer = null;
            try {
                pollingConsumer = endpoint.createPollingConsumer();
                this.consumerMap.put(uri, pollingConsumer);
                pollingConsumer.start();
            }
            catch (Exception ex) {
                LOG.error("Unexpected error in Consumer creation ", (Throwable)ex);
            }
            return pollingConsumer;
        }
        return this.consumerMap.get(uri);
    }
}

