/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.camel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.camel.AbstractCamelProvisioningManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class CamelUserProvisioningManager
extends AbstractCamelProvisioningManager
implements UserProvisioningManager {
    private static final Logger LOG = LoggerFactory.getLogger(CamelUserProvisioningManager.class);

    public Pair<String, List<PropagationStatus>> create(UserTO userTO, boolean nullPriorityAsync) {
        return this.create(userTO, true, false, null, Collections.emptySet(), nullPriorityAsync);
    }

    public Pair<String, List<PropagationStatus>> create(UserTO userTO, boolean storePassword, boolean nullPriorityAsync) {
        return this.create(userTO, storePassword, false, null, Collections.emptySet(), nullPriorityAsync);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Pair<String, List<PropagationStatus>> create(UserTO userTO, boolean storePassword, boolean disablePwdPolicyCheck, Boolean enabled, Set<String> excludedResources, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:createPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("storePassword", storePassword);
        props.put("disablePwdPolicyCheck", disablePwdPolicyCheck);
        props.put("enabled", enabled);
        props.put("excludedResources", excludedResources);
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:createUser", userTO, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (Pair)exchange.getIn().getBody(Pair.class);
    }

    public Pair<UserPatch, List<PropagationStatus>> update(UserPatch userPatch, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:updatePort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:updateUser", userPatch, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (Pair)exchange.getIn().getBody(Pair.class);
    }

    public Pair<UserPatch, List<PropagationStatus>> update(UserPatch anyPatch, Set<String> excludedResources, boolean nullPriorityAsync) {
        return this.update(anyPatch, new ProvisioningReport(), null, excludedResources, nullPriorityAsync);
    }

    public List<PropagationStatus> delete(String key, boolean nullPriorityAsync) {
        return this.delete(key, Collections.emptySet(), nullPriorityAsync);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<PropagationStatus> delete(String key, Set<String> excludedResources, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:deletePort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("excludedResources", excludedResources);
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:deleteUser", key, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (List)exchange.getIn().getBody(List.class);
    }

    public String unlink(UserPatch userPatch) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:unlinkPort");
        this.sendMessage("direct:unlinkUser", userPatch);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return ((UserPatch)exchange.getIn().getBody(UserPatch.class)).getKey();
    }

    public Pair<String, List<PropagationStatus>> activate(StatusPatch statusPatch, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:statusPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("token", statusPatch.getToken());
        props.put("key", statusPatch.getKey());
        props.put("statusPatch", statusPatch);
        props.put("nullPriorityAsync", nullPriorityAsync);
        if (statusPatch.isOnSyncope()) {
            this.sendMessage("direct:activateUser", statusPatch.getKey(), props);
        } else {
            WorkflowResult updated = new WorkflowResult((Object)statusPatch.getKey(), null, statusPatch.getType().name().toLowerCase());
            this.sendMessage("direct:userStatusPropagation", updated, props);
        }
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (Pair)exchange.getIn().getBody(Pair.class);
    }

    public Pair<String, List<PropagationStatus>> reactivate(StatusPatch statusPatch, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:statusPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("key", statusPatch.getKey());
        props.put("statusPatch", statusPatch);
        props.put("nullPriorityAsync", nullPriorityAsync);
        if (statusPatch.isOnSyncope()) {
            this.sendMessage("direct:reactivateUser", statusPatch.getKey(), props);
        } else {
            WorkflowResult updated = new WorkflowResult((Object)statusPatch.getKey(), null, statusPatch.getType().name().toLowerCase());
            this.sendMessage("direct:userStatusPropagation", updated, props);
        }
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (Pair)exchange.getIn().getBody(Pair.class);
    }

    public Pair<String, List<PropagationStatus>> suspend(StatusPatch statusPatch, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:statusPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("key", statusPatch.getKey());
        props.put("statusPatch", statusPatch);
        props.put("nullPriorityAsync", nullPriorityAsync);
        if (statusPatch.isOnSyncope()) {
            this.sendMessage("direct:suspendUser", statusPatch.getKey(), props);
        } else {
            WorkflowResult updated = new WorkflowResult((Object)statusPatch.getKey(), null, statusPatch.getType().name().toLowerCase());
            this.sendMessage("direct:userStatusPropagation", updated, props);
        }
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (Pair)exchange.getIn().getBody(Pair.class);
    }

    public String link(UserPatch anyPatch) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:linkPort");
        this.sendMessage("direct:linkUser", anyPatch);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return ((UserPatch)exchange.getIn().getBody(UserPatch.class)).getKey();
    }

    public List<PropagationStatus> provision(String key, boolean changePwd, String password, Collection<String> resources, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:provisionPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("key", key);
        props.put("changePwd", changePwd);
        props.put("password", password);
        props.put("resources", resources);
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:provisionUser", key, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (List)exchange.getIn().getBody(List.class);
    }

    public List<PropagationStatus> deprovision(String user, Collection<String> resources, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:deprovisionPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("resources", resources);
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:deprovisionUser", user, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (List)exchange.getIn().getBody(List.class);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Pair<UserPatch, List<PropagationStatus>> update(UserPatch userPatch, ProvisioningReport result, Boolean enabled, Set<String> excludedResources, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:updateInPullPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("key", userPatch.getKey());
        props.put("result", result);
        props.put("enabled", enabled);
        props.put("excludedResources", excludedResources);
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:updateUserInPull", userPatch, props);
        Exchange exchange = pollingConsumer.receive();
        Exception ex = (Exception)exchange.getProperty("CamelExceptionCaught");
        if (ex != null) {
            LOG.error("Update of user {} failed, trying to pull its status anyway (if configured)", (Object)nullPriorityAsync, (Object)ex);
            result.setStatus(ProvisioningReport.Status.FAILURE);
            result.setMessage("Update failed, trying to pull status anyway (if configured)\n" + ex.getMessage());
            WorkflowResult updated = new WorkflowResult((Object)Pair.of((Object)userPatch, (Object)false), new PropagationByResource(), new HashSet());
            this.sendMessage("direct:userInPull", updated, props);
            exchange = pollingConsumer.receive();
        }
        return (Pair)exchange.getIn().getBody(Pair.class);
    }

    public void internalSuspend(String key) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:internalSuspendUserPort");
        this.sendMessage("direct:internalSuspendUser", key);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
    }

    public void requestPasswordReset(String key) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:requestPwdResetPort");
        this.sendMessage("direct:requestPwdReset", key);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
    }

    public void confirmPasswordReset(String key, String token, String password) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:confirmPwdResetPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("key", key);
        props.put("token", token);
        props.put("password", password);
        this.sendMessage("direct:confirmPwdReset", key, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
    }
}

