/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable;

import java.util.HashMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;

@Component
public class FlowableLiquibasePropertySourcesPlaceholderConfigurer
extends PropertySourcesPlaceholderConfigurer
implements EnvironmentAware,
InitializingBean {
    private static final String LIQUIBASE_PROPERTY = "spring.liquibase.enabled";
    private ConfigurableEnvironment env;

    public void setEnvironment(Environment env) {
        this.env = (ConfigurableEnvironment)env;
        super.setEnvironment(env);
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.env.containsProperty(LIQUIBASE_PROPERTY)) {
            HashMap<String, Boolean> props = new HashMap<String, Boolean>();
            props.put(LIQUIBASE_PROPERTY, false);
            this.env.getPropertySources().addLast((PropertySource)new MapPropertySource("flowable-liquibase-override", props));
        }
    }
}

