/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client;

import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.rest.RestClientFactoryBean;
import org.apache.syncope.common.search.OrderByClauseBuilder;
import org.apache.syncope.common.search.RoleFiqlSearchConditionBuilder;
import org.apache.syncope.common.search.UserFiqlSearchConditionBuilder;
import org.apache.syncope.common.services.UserSelfService;
import org.apache.syncope.common.services.WorkflowService;
import org.apache.syncope.common.types.Preference;
import org.apache.syncope.common.types.SubjectType;

public class SyncopeClient {
    private final MediaType mediaType;
    private final RestClientFactoryBean restClientFactory;
    private final String username;
    private final String password;

    public SyncopeClient(MediaType mediaType, RestClientFactoryBean restClientFactory, String username, String password) {
        this.mediaType = mediaType;
        this.restClientFactory = restClientFactory;
        this.username = username;
        this.password = password;
    }

    public static UserFiqlSearchConditionBuilder getUserSearchConditionBuilder() {
        return new UserFiqlSearchConditionBuilder();
    }

    public static RoleFiqlSearchConditionBuilder getRoleSearchConditionBuilder() {
        return new RoleFiqlSearchConditionBuilder();
    }

    public static OrderByClauseBuilder getOrderByClauseBuilder() {
        return new OrderByClauseBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(Class<T> serviceClass) {
        RestClientFactoryBean restClientFactoryBean = this.restClientFactory;
        synchronized (restClientFactoryBean) {
            return this.restClientFactory.createServiceInstance(serviceClass, this.mediaType, this.username, this.password);
        }
    }

    public <T> T header(T service, String key, Object ... values) {
        WebClient.client(service).header(key, values);
        return service;
    }

    public <T> T header(Class<T> serviceClass, String key, Object ... values) {
        return this.header(this.getService(serviceClass), key, values);
    }

    public <T> T prefer(T service, Preference preference) {
        return this.header(service, "Prefer", preference.toString());
    }

    public <T> T prefer(Class<T> serviceClass, Preference preference) {
        return this.header(serviceClass, "Prefer", new Object[]{preference.toString()});
    }

    private <T> T match(T service, EntityTag etag, boolean ifNot) {
        WebClient.client(service).match(etag, ifNot);
        return service;
    }

    public <T> T ifMatch(T service, EntityTag etag) {
        return this.match(service, etag, false);
    }

    public <T> T ifMatch(Class<T> serviceClass, EntityTag etag) {
        return this.match(this.getService(serviceClass), etag, false);
    }

    public <T> T ifNoneMatch(T service, EntityTag etag) {
        return this.match(service, etag, true);
    }

    public <T> T ifNoneMatch(Class<T> serviceClass, EntityTag etag) {
        return this.match(this.getService(serviceClass), etag, true);
    }

    public boolean isSelfRegAllowed() {
        return Boolean.valueOf(this.restClientFactory.createServiceInstance(UserSelfService.class, this.mediaType, null, null).getOptions().getHeaderString("Syncope.SelfRegistration.Allowed"));
    }

    public boolean isPwdResetAllowed() {
        return Boolean.valueOf(this.restClientFactory.createServiceInstance(UserSelfService.class, this.mediaType, null, null).getOptions().getHeaderString("Syncope.PasswordReset.Allowed"));
    }

    public boolean isPwdResetRequiringSecurityQuestions() {
        return Boolean.valueOf(this.restClientFactory.createServiceInstance(UserSelfService.class, this.mediaType, null, null).getOptions().getHeaderString("Syncope.PasswordReset.SecurityQuestions"));
    }

    public boolean isActivitiEnabledFor(SubjectType subjectType) {
        boolean result;
        Response options = this.getService(WorkflowService.class).getOptions(subjectType);
        switch (subjectType) {
            case ROLE: {
                result = Boolean.valueOf(options.getHeaderString("Syncope.Activiti.Role.Enabled"));
                break;
            }
            default: {
                result = Boolean.valueOf(options.getHeaderString("Syncope.Activiti.User.Enabled"));
            }
        }
        return result;
    }

    public <T> EntityTag getLatestEntityTag(T service) {
        return WebClient.client(service).getResponse().getEntityTag();
    }
}

