/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.reqres;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.AbstractBaseBean;

@XmlRootElement(name="bulkActionResult")
@XmlType
public class BulkActionResult
extends AbstractBaseBean {
    private static final long serialVersionUID = 2868894178821778133L;
    private final List<Result> results = new ArrayList<Result>();

    @XmlElementWrapper(name="result")
    @XmlElement(name="item")
    @JsonProperty(value="result")
    public List<Result> getResult() {
        return this.results;
    }

    @JsonIgnore
    public void add(Object id, Status status) {
        if (id != null) {
            this.results.add(new Result(id.toString(), status));
        }
    }

    @JsonIgnore
    public void add(Object id, String status) {
        if (id != null) {
            this.results.add(new Result(id.toString(), Status.valueOf(status.toUpperCase())));
        }
    }

    @JsonIgnore
    public Map<String, Status> getResultMap() {
        HashMap<String, Status> res = new HashMap<String, Status>();
        for (Result result : this.results) {
            res.put(result.getKey(), result.getValue());
        }
        return res;
    }

    @JsonIgnore
    public List<String> getResultByStatus(Status status) {
        ArrayList<String> res = new ArrayList<String>();
        for (Result result : this.results) {
            if (result.getValue() != status) continue;
            res.add(result.getKey());
        }
        return res;
    }

    public static class Result
    extends AbstractBaseBean {
        private static final long serialVersionUID = -1149681964161193232L;
        private String key;
        private Status value;

        public Result() {
        }

        public Result(String key, Status value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Status getValue() {
            return this.value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(Status value) {
            this.value = value;
        }
    }

    @XmlEnum
    @XmlType(name="bulkActionStatus")
    public static enum Status {
        SUCCESS,
        FAILURE,
        CREATED,
        SUBMITTED,
        UNSUBMITTED;

    }
}

