/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.services;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.apache.syncope.common.reqres.BulkAction;
import org.apache.syncope.common.reqres.BulkActionResult;
import org.apache.syncope.common.services.JAXRSService;
import org.apache.syncope.common.to.ConnBundleTO;
import org.apache.syncope.common.to.ConnIdObjectClassTO;
import org.apache.syncope.common.to.ConnInstanceTO;
import org.apache.syncope.common.to.SchemaTO;
import org.apache.syncope.common.types.ConnConfProperty;

@Path(value="connectors")
public interface ConnectorService
extends JAXRSService {
    @GET
    @Path(value="bundles")
    @Produces(value={"application/xml", "application/json"})
    public List<ConnBundleTO> getBundles(@QueryParam(value="lang") String var1);

    @GET
    @Path(value="{connInstanceId}/configuration")
    @Produces(value={"application/xml", "application/json"})
    public List<ConnConfProperty> getConfigurationProperties(@NotNull @PathParam(value="connInstanceId") Long var1);

    @POST
    @Path(value="{connInstanceId}/schemaNames")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public List<SchemaTO> getSchemaNames(@NotNull @PathParam(value="connInstanceId") Long var1, @NotNull ConnInstanceTO var2, @QueryParam(value="includeSpecial") @DefaultValue(value="false") boolean var3);

    @POST
    @Path(value="{connInstanceId}/supportedObjectClasses")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public List<ConnIdObjectClassTO> getSupportedObjectClasses(@NotNull @PathParam(value="connInstanceId") Long var1, @NotNull ConnInstanceTO var2);

    @GET
    @Path(value="{connInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public ConnInstanceTO read(@NotNull @PathParam(value="connInstanceId") Long var1);

    @GET
    @Path(value="byResource/{resourceName}")
    @Produces(value={"application/xml", "application/json"})
    public ConnInstanceTO readByResource(@NotNull @PathParam(value="resourceName") String var1);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public List<ConnInstanceTO> list(@QueryParam(value="lang") String var1);

    @Descriptions(value={@Description(target="response", value="Featuring <tt>Location</tt> header of created connector instance")})
    @POST
    @Consumes(value={"application/xml", "application/json"})
    public Response create(@NotNull ConnInstanceTO var1);

    @PUT
    @Path(value="{connInstanceId}")
    @Consumes(value={"application/xml", "application/json"})
    public void update(@NotNull @PathParam(value="connInstanceId") Long var1, @NotNull ConnInstanceTO var2);

    @DELETE
    @Path(value="{connInstanceId}")
    public void delete(@NotNull @PathParam(value="connInstanceId") Long var1);

    @POST
    @Path(value="check")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public boolean check(@NotNull ConnInstanceTO var1);

    @POST
    @Path(value="reload")
    public void reload();

    @POST
    @Path(value="bulk")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public BulkActionResult bulk(@NotNull BulkAction var1);
}

