/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.services;

import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.apache.syncope.common.mod.ResourceAssociationMod;
import org.apache.syncope.common.mod.StatusMod;
import org.apache.syncope.common.mod.UserMod;
import org.apache.syncope.common.reqres.BulkAction;
import org.apache.syncope.common.reqres.BulkActionResult;
import org.apache.syncope.common.reqres.PagedResult;
import org.apache.syncope.common.services.JAXRSService;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.types.ResourceAssociationActionType;
import org.apache.syncope.common.types.ResourceDeassociationActionType;
import org.apache.syncope.common.wrap.ResourceName;

@Path(value="users")
public interface UserService
extends JAXRSService {
    @Descriptions(value={@Description(target="response", value="Featuring HTTP header with username matching the given userId")})
    @OPTIONS
    @Path(value="{userId}/username")
    public Response getUsername(@NotNull @PathParam(value="userId") Long var1);

    @Descriptions(value={@Description(target="response", value="Featuring HTTP header with userId matching the given username")})
    @OPTIONS
    @Path(value="{username}/userId")
    public Response getUserId(@NotNull @PathParam(value="username") String var1);

    @GET
    @Path(value="{userId}")
    @Produces(value={"application/xml", "application/json"})
    public UserTO read(@NotNull @PathParam(value="userId") Long var1);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<UserTO> list();

    @GET
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<UserTO> list(@QueryParam(value="orderby") String var1);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<UserTO> list(@NotNull @Min(value=1L) @QueryParam(value="page") @DefaultValue(value="1") Integer var1, @NotNull @Min(value=1L) @QueryParam(value="size") @DefaultValue(value="25") Integer var2);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<UserTO> list(@NotNull @Min(value=1L) @QueryParam(value="page") @DefaultValue(value="1") Integer var1, @NotNull @Min(value=1L) @QueryParam(value="size") @DefaultValue(value="25") Integer var2, @QueryParam(value="orderby") String var3);

    @GET
    @Path(value="search")
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<UserTO> search(@NotNull @QueryParam(value="fiql") String var1);

    @GET
    @Path(value="search")
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<UserTO> search(@NotNull @QueryParam(value="fiql") String var1, @QueryParam(value="orderby") String var2);

    @GET
    @Path(value="search")
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<UserTO> search(@QueryParam(value="fiql") String var1, @NotNull @Min(value=1L) @QueryParam(value="page") @DefaultValue(value="1") Integer var2, @NotNull @Min(value=1L) @QueryParam(value="size") @DefaultValue(value="25") Integer var3);

    @GET
    @Path(value="search")
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<UserTO> search(@QueryParam(value="fiql") String var1, @NotNull @Min(value=1L) @QueryParam(value="page") @DefaultValue(value="1") Integer var2, @NotNull @Min(value=1L) @QueryParam(value="size") @DefaultValue(value="25") Integer var3, @QueryParam(value="orderby") String var4);

    @Descriptions(value={@Description(target="response", value="Featuring <tt>Location</tt> header of created user as well as the user itself enriched with propagation status information - <tt>UserTO</tt> as <tt>Entity</tt>")})
    @POST
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response create(@NotNull UserTO var1, @DefaultValue(value="true") @QueryParam(value="storePassword") boolean var2);

    @Descriptions(value={@Description(target="response", value="Featuring the updated user enriched with propagation status information - <tt>UserTO</tt> as <tt>Entity</tt>")})
    @POST
    @Path(value="{userId}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response update(@NotNull @PathParam(value="userId") Long var1, @NotNull UserMod var2);

    @Descriptions(value={@Description(target="response", value="Featuring the updated user enriched with propagation status information - <tt>UserTO</tt> as <tt>Entity</tt>")})
    @POST
    @Path(value="{userId}/status")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response status(@NotNull @PathParam(value="userId") Long var1, @NotNull StatusMod var2);

    @Descriptions(value={@Description(target="response", value="Featuring the deleted user enriched with propagation status information - <tt>UserTO</tt> as <tt>Entity</tt>")})
    @DELETE
    @Path(value="{userId}")
    @Produces(value={"application/xml", "application/json"})
    public Response delete(@NotNull @PathParam(value="userId") Long var1);

    @Descriptions(value={@Description(target="response", value="Featuring <tt>BulkActionResult</tt> as <tt>Entity</tt>")})
    @POST
    @Path(value="{userId}/bulkDeassociation/{type}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response bulkDeassociation(@NotNull @PathParam(value="userId") Long var1, @NotNull @PathParam(value="type") ResourceDeassociationActionType var2, @NotNull List<ResourceName> var3);

    @Descriptions(value={@Description(target="response", value="Featuring <tt>BulkActionResult</tt> as <tt>Entity</tt>")})
    @POST
    @Path(value="{userId}/bulkAssociation/{type}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response bulkAssociation(@NotNull @PathParam(value="userId") Long var1, @NotNull @PathParam(value="type") ResourceAssociationActionType var2, @NotNull ResourceAssociationMod var3);

    @POST
    @Path(value="bulk")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public BulkActionResult bulk(@NotNull BulkAction var1);
}

