/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.services;

import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.apache.syncope.common.mod.RoleMod;
import org.apache.syncope.common.reqres.BulkAction;
import org.apache.syncope.common.reqres.BulkActionResult;
import org.apache.syncope.common.reqres.PagedResult;
import org.apache.syncope.common.services.JAXRSService;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.types.ResourceAssociationActionType;
import org.apache.syncope.common.types.ResourceDeassociationActionType;
import org.apache.syncope.common.wrap.ResourceName;

@Path(value="roles")
public interface RoleService
extends JAXRSService {
    @GET
    @Path(value="{roleId}/children")
    @Produces(value={"application/xml", "application/json"})
    public List<RoleTO> children(@NotNull @PathParam(value="roleId") Long var1);

    @GET
    @Path(value="{roleId}/parent")
    @Produces(value={"application/xml", "application/json"})
    public RoleTO parent(@NotNull @PathParam(value="roleId") Long var1);

    @GET
    @Path(value="{roleId}")
    @Produces(value={"application/xml", "application/json"})
    public RoleTO read(@NotNull @PathParam(value="roleId") Long var1);

    @Descriptions(value={@Description(target="method", value="This method is similar to <tt>read()</tt>, but uses different authentication handling to ensure that a user can read his own roles.")})
    @GET
    @Path(value="{roleId}/own")
    @Produces(value={"application/xml", "application/json"})
    public RoleTO readSelf(@NotNull @PathParam(value="roleId") Long var1);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<RoleTO> list();

    @GET
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<RoleTO> list(@QueryParam(value="orderby") String var1);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<RoleTO> list(@NotNull @Min(value=1L) @QueryParam(value="page") @DefaultValue(value="1") Integer var1, @NotNull @Min(value=1L) @QueryParam(value="size") @DefaultValue(value="25") Integer var2);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<RoleTO> list(@NotNull @Min(value=1L) @QueryParam(value="page") @DefaultValue(value="1") Integer var1, @NotNull @Min(value=1L) @QueryParam(value="size") @DefaultValue(value="25") Integer var2, @QueryParam(value="orderby") String var3);

    @GET
    @Path(value="search")
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<RoleTO> search(@NotNull @QueryParam(value="fiql") String var1);

    @GET
    @Path(value="search")
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<RoleTO> search(@NotNull @QueryParam(value="fiql") String var1, @QueryParam(value="orderby") String var2);

    @GET
    @Path(value="search")
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<RoleTO> search(@QueryParam(value="fiql") String var1, @NotNull @Min(value=1L) @QueryParam(value="page") @DefaultValue(value="1") Integer var2, @NotNull @Min(value=1L) @QueryParam(value="size") @DefaultValue(value="25") Integer var3);

    @GET
    @Path(value="search")
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<RoleTO> search(@QueryParam(value="fiql") String var1, @NotNull @Min(value=1L) @QueryParam(value="page") @DefaultValue(value="1") Integer var2, @NotNull @Min(value=1L) @QueryParam(value="size") @DefaultValue(value="25") Integer var3, @QueryParam(value="orderby") String var4);

    @Descriptions(value={@Description(target="response", value="Featuring <tt>Location</tt> header of created role as well as the role itself enriched with propagation status information - <tt>RoleTO</tt> as <tt>Entity</tt>")})
    @POST
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response create(@NotNull RoleTO var1);

    @Descriptions(value={@Description(target="response", value="Featuring the updated role enriched with propagation status information - <tt>RoleTO</tt> as <tt>Entity</tt>")})
    @POST
    @Path(value="{roleId}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response update(@NotNull @PathParam(value="roleId") Long var1, @NotNull RoleMod var2);

    @Descriptions(value={@Description(target="response", value="Featuring the deleted role enriched with propagation status information - <tt>RoleTO</tt> as <tt>Entity</tt>")})
    @DELETE
    @Path(value="{roleId}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response delete(@NotNull @PathParam(value="roleId") Long var1);

    @Descriptions(value={@Description(target="response", value="Featuring <tt>BulkActionResult</tt> as <tt>Entity</tt>")})
    @POST
    @Path(value="{roleId}/deassociate/{type}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response bulkDeassociation(@NotNull @PathParam(value="roleId") Long var1, @NotNull @PathParam(value="type") ResourceDeassociationActionType var2, @NotNull List<ResourceName> var3);

    @Descriptions(value={@Description(target="response", value="Featuring <tt>BulkActionResult</tt> as <tt>Entity</tt>")})
    @POST
    @Path(value="{roleId}/associate/{type}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response bulkAssociation(@NotNull @PathParam(value="roleId") Long var1, @NotNull @PathParam(value="type") ResourceAssociationActionType var2, @NotNull List<ResourceName> var3);

    @POST
    @Path(value="bulk")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public BulkActionResult bulk(@NotNull BulkAction var1);
}

