/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.AbstractBaseBean;
import org.apache.syncope.common.to.WorkflowFormPropertyTO;

@XmlRootElement(name="workflowForm")
@XmlType
public class WorkflowFormTO
extends AbstractBaseBean {
    private static final long serialVersionUID = -7044543391316529128L;
    private long userId;
    private String taskId;
    private String key;
    private String description;
    private Date createTime;
    private Date dueDate;
    private String owner;
    private final List<WorkflowFormPropertyTO> properties = new ArrayList<WorkflowFormPropertyTO>();

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @XmlElementWrapper(name="workflowFormProperties")
    @XmlElement(name="workflowFormProperty")
    @JsonProperty(value="workflowFormProperties")
    public List<WorkflowFormPropertyTO> getProperties() {
        return this.properties;
    }

    public boolean addProperty(WorkflowFormPropertyTO property) {
        return this.properties.contains(property) ? true : this.properties.add(property);
    }

    public boolean removeProperty(WorkflowFormPropertyTO property) {
        return this.properties.remove(property);
    }

    public void setProperties(Collection<WorkflowFormPropertyTO> properties) {
        if (this.properties != properties) {
            this.properties.clear();
            if (properties != null) {
                this.properties.addAll(properties);
            }
        }
    }

    @JsonIgnore
    public Map<String, WorkflowFormPropertyTO> getPropertyMap() {
        Map<String, WorkflowFormPropertyTO> result;
        if (this.getProperties() == null) {
            result = Collections.emptyMap();
        } else {
            result = new HashMap();
            for (WorkflowFormPropertyTO prop : this.getProperties()) {
                result.put(prop.getId(), prop);
            }
            result = Collections.unmodifiableMap(result);
        }
        return result;
    }

    @JsonIgnore
    public Map<String, String> getPropertiesForSubmit() {
        HashMap<String, String> props = new HashMap<String, String>();
        for (WorkflowFormPropertyTO prop : this.getProperties()) {
            if (!prop.isWritable()) continue;
            props.put(prop.getId(), prop.getValue());
        }
        return props;
    }
}

