/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.reqres;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

public class DateParamConverterProvider
implements ParamConverterProvider {
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.applyPattern("yyyy-MM-dd'T'HH:mm:ssZ");
            return sdf;
        }
    };

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (Date.class.equals(rawType)) {
            return new DateParamConverter();
        }
        return null;
    }

    private static class DateParamConverter
    implements ParamConverter<Date> {
        private DateParamConverter() {
        }

        public Date fromString(String value) {
            try {
                return ((SimpleDateFormat)DATE_FORMAT.get()).parse(value);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Unparsable date: " + value, e);
            }
        }

        public String toString(Date value) {
            return ((SimpleDateFormat)DATE_FORMAT.get()).format(value);
        }
    }
}

