/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.services;

import java.util.Date;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.apache.syncope.common.reqres.BulkAction;
import org.apache.syncope.common.reqres.BulkActionResult;
import org.apache.syncope.common.reqres.PagedResult;
import org.apache.syncope.common.services.JAXRSService;
import org.apache.syncope.common.to.AbstractTaskTO;
import org.apache.syncope.common.to.ReportExecTO;
import org.apache.syncope.common.to.SchedTaskTO;
import org.apache.syncope.common.to.TaskExecTO;
import org.apache.syncope.common.types.JobAction;
import org.apache.syncope.common.types.JobStatusType;
import org.apache.syncope.common.types.TaskType;
import org.apache.syncope.common.wrap.JobClass;
import org.apache.syncope.common.wrap.PushActionClass;
import org.apache.syncope.common.wrap.SyncActionClass;

@Path(value="tasks")
public interface TaskService
extends JAXRSService {
    @GET
    @Path(value="jobClasses")
    @Produces(value={"application/xml", "application/json"})
    public List<JobClass> getJobClasses();

    @GET
    @Path(value="syncActionsClasses")
    @Produces(value={"application/xml", "application/json"})
    public List<SyncActionClass> getSyncActionsClasses();

    @GET
    @Path(value="pushActionsClasses")
    @Produces(value={"application/xml", "application/json"})
    public List<PushActionClass> getPushActionsClasses();

    @GET
    @Path(value="{taskId}")
    @Produces(value={"application/xml", "application/json"})
    public <T extends AbstractTaskTO> T read(@NotNull @PathParam(value="taskId") Long var1, @QueryParam(value="details") @DefaultValue(value="true") boolean var2);

    @GET
    @Path(value="executions/{executionId}")
    @Produces(value={"application/xml", "application/json"})
    public TaskExecTO readExecution(@NotNull @PathParam(value="executionId") Long var1);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public <T extends AbstractTaskTO> PagedResult<T> list(@NotNull @MatrixParam(value="type") TaskType var1);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public <T extends AbstractTaskTO> PagedResult<T> list(@NotNull @MatrixParam(value="type") TaskType var1, @QueryParam(value="orderby") String var2);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public <T extends AbstractTaskTO> PagedResult<T> list(@NotNull @MatrixParam(value="type") TaskType var1, @NotNull @Min(value=1L) @QueryParam(value="page") @DefaultValue(value="1") Integer var2, @NotNull @Min(value=1L) @QueryParam(value="size") @DefaultValue(value="25") Integer var3, @QueryParam(value="orderby") String var4, @QueryParam(value="details") @DefaultValue(value="true") boolean var5);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public <T extends AbstractTaskTO> PagedResult<T> list(@MatrixParam(value="type") TaskType var1, @NotNull @Min(value=1L) @QueryParam(value="page") @DefaultValue(value="1") Integer var2, @NotNull @Min(value=1L) @QueryParam(value="size") @DefaultValue(value="25") Integer var3);

    @GET
    @Path(value="{taskId}/executions")
    @Produces(value={"application/xml", "application/json"})
    public PagedResult<TaskExecTO> listExecutions(@NotNull @PathParam(value="taskId") Long var1, @NotNull @Min(value=1L) @QueryParam(value="page") @DefaultValue(value="1") Integer var2, @NotNull @Min(value=1L) @QueryParam(value="size") @DefaultValue(value="25") Integer var3);

    @Descriptions(value={@Description(target="response", value="Featuring <tt>Location</tt> header of created task")})
    @POST
    @Consumes(value={"application/xml", "application/json"})
    public <T extends SchedTaskTO> Response create(@NotNull T var1);

    @PUT
    @Path(value="{taskId}")
    @Consumes(value={"application/xml", "application/json"})
    public void update(@NotNull @PathParam(value="taskId") Long var1, @NotNull AbstractTaskTO var2);

    @DELETE
    @Path(value="{taskId}")
    public void delete(@NotNull @PathParam(value="taskId") Long var1);

    @DELETE
    @Path(value="executions/{executionId}")
    public void deleteExecution(@NotNull @PathParam(value="executionId") Long var1);

    @DELETE
    @Path(value="{taskId}/executions")
    @Produces(value={"application/xml", "application/json"})
    public BulkActionResult deleteExecutions(@NotNull @PathParam(value="taskId") Long var1, @QueryParam(value="startedBefore") Date var2, @QueryParam(value="startedAfter") Date var3, @QueryParam(value="endedBefore") Date var4, @QueryParam(value="endedAfter") Date var5);

    @POST
    @Path(value="{taskId}/execute")
    @Produces(value={"application/xml", "application/json"})
    public TaskExecTO execute(@NotNull @PathParam(value="taskId") Long var1, @QueryParam(value="dryRun") @DefaultValue(value="false") boolean var2);

    @POST
    @Path(value="executions/{executionId}/report")
    @Consumes(value={"application/xml", "application/json"})
    public void report(@NotNull @PathParam(value="executionId") Long var1, @NotNull ReportExecTO var2);

    @POST
    @Path(value="bulk")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public BulkActionResult bulk(@NotNull BulkAction var1);

    @GET
    @Path(value="jobs")
    @Produces(value={"application/xml", "application/json"})
    public List<TaskExecTO> listJobs(@MatrixParam(value="type") JobStatusType var1);

    @POST
    @Path(value="{taskId}")
    public void actionJob(@PathParam(value="taskId") Long var1, @QueryParam(value="action") JobAction var2);
}

